/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.config.provider.RateLimitConfig;
import com.tencent.polaris.api.plugin.ratelimiter.InitCriteria;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaBucket;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.api.plugin.ratelimiter.ServiceRateLimiter;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.RateLimitExtension;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindowSet;
import com.tencent.polaris.ratelimit.client.pojo.CommonQuotaRequest;
import com.tencent.polaris.ratelimit.client.sync.RemoteSyncTask;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class RateLimitWindow {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitWindow.class);
    private final RateLimitWindowSet windowSet;
    private final ServiceKey svcKey;
    private final String labels;
    private final String uniqueKey;
    private final int hashValue;
    private final FlowControlParam syncParam;
    private final Object initLock = new Object();
    private final AtomicInteger status = new AtomicInteger();
    private final AtomicLong lastAccessTimeMs = new AtomicLong();
    private final QuotaBucket allocatingBucket;
    private final long expireDurationMs;
    private final ServiceKey remoteCluster;
    private final ServiceInstances remoteAddresses;
    private final RateLimitProto.Rule rule;
    private int configMode;
    private final RateLimitConfig rateLimitConfig;

    public RateLimitWindow(RateLimitWindowSet windowSet, CommonQuotaRequest quotaRequest, String labelsStr, RateLimitConfig rateLimitConfig, InitCriteria initCriteria) {
        RateLimitProto.Rule rule;
        this.status.set(WindowStatus.CREATED.ordinal());
        this.rule = rule = initCriteria.getRule();
        this.windowSet = windowSet;
        this.svcKey = quotaRequest.getSvcEventKey().getServiceKey();
        this.labels = labelsStr;
        this.uniqueKey = this.buildQuotaUniqueKey(rule.getRevision().getValue());
        initCriteria.setWindowKey(this.uniqueKey);
        this.hashValue = this.uniqueKey.hashCode();
        this.expireDurationMs = RateLimitWindow.getExpireDurationMs(rule);
        this.syncParam = quotaRequest.getFlowControlParam();
        this.remoteCluster = this.getLimiterClusterService(rule.getCluster(), rateLimitConfig);
        this.remoteAddresses = this.buildDefaultInstances(rateLimitConfig.getLimiterAddresses());
        this.allocatingBucket = RateLimitWindow.getQuotaBucket(initCriteria, windowSet.getRateLimitExtension());
        this.lastAccessTimeMs.set(System.currentTimeMillis());
        this.rateLimitConfig = rateLimitConfig;
        this.buildRemoteConfigMode();
    }

    private ServiceInstances buildDefaultInstances(List<String> addresses) {
        if (CollectionUtils.isEmpty(addresses)) {
            return null;
        }
        ArrayList<DefaultInstance> instances = new ArrayList<DefaultInstance>();
        for (String address : addresses) {
            DefaultInstance defaultInstance = new DefaultInstance();
            defaultInstance.setId(address);
            String[] tokens = address.split(":");
            defaultInstance.setHost(tokens[0]);
            defaultInstance.setPort(Integer.parseInt(tokens[1]));
            defaultInstance.setHealthy(true);
            defaultInstance.setWeight(100);
            instances.add(defaultInstance);
        }
        return new DefaultServiceInstances(new ServiceKey("", ""), instances);
    }

    private ServiceKey getLimiterClusterService(RateLimitProto.RateLimitCluster cluster, RateLimitConfig rateLimitConfig) {
        if (null != cluster && StringUtils.isNotBlank((String)cluster.getNamespace().getValue()) && StringUtils.isNotBlank((String)cluster.getService().getValue())) {
            return new ServiceKey(cluster.getNamespace().getValue(), cluster.getService().getValue());
        }
        if (StringUtils.isNotBlank((String)rateLimitConfig.getLimiterNamespace()) && StringUtils.isNotBlank((String)rateLimitConfig.getLimiterService())) {
            return new ServiceKey(rateLimitConfig.getLimiterNamespace(), rateLimitConfig.getLimiterService());
        }
        return null;
    }

    private void buildRemoteConfigMode() {
        if (RateLimitProto.Rule.Type.LOCAL.equals((Object)this.rule.getType())) {
            this.configMode = 0;
            return;
        }
        if (null == this.remoteCluster && null == this.remoteAddresses) {
            this.configMode = 0;
            LOG.warn("remote limiter service or addresses not configured, degrade to local mode");
            return;
        }
        this.configMode = 1;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    private static QuotaBucket getQuotaBucket(InitCriteria criteria, RateLimitExtension extension) {
        String action = criteria.getRule().getAction().getValue();
        ServiceRateLimiter rateLimiter = null;
        if (StringUtils.isNotBlank((String)action)) {
            rateLimiter = extension.getRateLimiter(action);
        }
        if (null == rateLimiter) {
            rateLimiter = extension.getDefaultRateLimiter();
        }
        return rateLimiter.initQuota(criteria);
    }

    private static long getExpireDurationMs(RateLimitProto.Rule rule) {
        return RateLimitWindow.getMaxSeconds(rule) * 1000L + 1000L;
    }

    private static long getMaxSeconds(RateLimitProto.Rule rule) {
        long maxSeconds = 0L;
        for (RateLimitProto.Amount amount : rule.getAmountsList()) {
            long seconds = amount.getValidDuration().getSeconds();
            if (maxSeconds != 0L && seconds <= maxSeconds) continue;
            maxSeconds = seconds;
        }
        return maxSeconds;
    }

    private String buildQuotaUniqueKey(String ruleRevision) {
        StringBuilder builder = new StringBuilder();
        builder.append(ruleRevision).append("#");
        builder.append(this.svcKey.getService()).append("#");
        builder.append(this.svcKey.getNamespace());
        if (StringUtils.isNotBlank((String)this.labels)) {
            builder.append("#");
            builder.append(this.labels);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.status.compareAndSet(WindowStatus.CREATED.ordinal(), WindowStatus.INITIALIZING.ordinal())) {
                return;
            }
            if (this.configMode == 0) {
                this.status.set(WindowStatus.INITIALIZED.ordinal());
                return;
            }
            this.windowSet.getRateLimitExtension().submitSyncTask(new RemoteSyncTask(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unInit() {
        Object object = this.initLock;
        synchronized (object) {
            if (this.status.get() == WindowStatus.DELETED.ordinal()) {
                return;
            }
            this.status.set(WindowStatus.DELETED.ordinal());
            this.windowSet.getRateLimitExtension().stopSyncTask(this.uniqueKey);
        }
    }

    public QuotaResult allocateQuota(int count) {
        long curTimeMs = System.currentTimeMillis();
        this.lastAccessTimeMs.set(curTimeMs);
        return this.allocatingBucket.allocateQuota(curTimeMs, count);
    }

    public boolean isExpired() {
        boolean expired;
        long curTimeMs = System.currentTimeMillis();
        boolean bl = expired = curTimeMs - this.lastAccessTimeMs.get() > this.expireDurationMs;
        if (expired) {
            LOG.info("[RateLimit]window has expired, expireDurationMs {}, uniqueKey {}", (Object)this.expireDurationMs, (Object)this.uniqueKey);
        }
        return expired;
    }

    public WindowStatus getStatus() {
        return ((WindowStatus[])WindowStatus.class.getEnumConstants())[this.status.get()];
    }

    public void setStatus(int value) {
        this.status.set(value);
    }

    public RateLimitWindowSet getWindowSet() {
        return this.windowSet;
    }

    public QuotaBucket getAllocatingBucket() {
        return this.allocatingBucket;
    }

    public ServiceKey getRemoteCluster() {
        return this.remoteCluster;
    }

    public ServiceInstances getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public ServiceKey getSvcKey() {
        return this.svcKey;
    }

    public String getLabels() {
        return this.labels;
    }

    public RateLimitProto.Rule getRule() {
        return this.rule;
    }

    public RateLimitConfig getRateLimitConfig() {
        return this.rateLimitConfig;
    }

    public static enum WindowStatus {
        CREATED,
        INITIALIZING,
        INITIALIZED,
        DELETED;

    }
}

