/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.api.plugin.registry.AbstractResourceEventListener;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.client.pb.ModelProto;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.client.flow.RateLimitExtension;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindowSet;
import com.tencent.polaris.ratelimit.client.pojo.CommonQuotaRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class QuotaFlow
extends Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaFlow.class);
    private RateLimitExtension rateLimitExtension;
    private String clientId;
    private final Map<ServiceKey, RateLimitWindowSet> svcToWindowSet = new ConcurrentHashMap<ServiceKey, RateLimitWindowSet>();

    public void init(Extensions extensions) throws PolarisException {
        this.clientId = extensions.getValueContext().getClientId();
        this.rateLimitExtension = new RateLimitExtension(extensions);
        extensions.getLocalRegistry().registerResourceListener((ResourceEventListener)new RateLimitRuleListener());
        this.rateLimitExtension.submitExpireJob(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : QuotaFlow.this.svcToWindowSet.entrySet()) {
                    ((RateLimitWindowSet)entry.getValue()).cleanupContainers();
                }
            }
        });
    }

    protected void doDestroy() {
        this.rateLimitExtension.destroy();
    }

    public QuotaResponse getQuota(CommonQuotaRequest request) throws PolarisException {
        RateLimitWindow rateLimitWindow = this.lookupRateLimitWindow(request);
        if (null == rateLimitWindow) {
            return new QuotaResponse(new QuotaResult(QuotaResult.Code.QuotaResultOk, 0L, "quota rule not exists"));
        }
        rateLimitWindow.init();
        return new QuotaResponse(rateLimitWindow.allocateQuota(request.getCount()));
    }

    private RateLimitWindow lookupRateLimitWindow(CommonQuotaRequest request) throws PolarisException {
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.rateLimitExtension.getExtensions(), (boolean)false, (ServiceEventKeysProvider)request, (FlowControlParam)request.getFlowControlParam());
        ServiceRule serviceRule = resourcesResponse.getServiceRule(request.getSvcEventKey());
        RateLimitProto.Rule rule = this.lookupRule(serviceRule, request.getLabels());
        if (null == rule) {
            return null;
        }
        request.setTargetRule(rule);
        ServiceKey serviceKey = request.getSvcEventKey().getServiceKey();
        String labelsStr = QuotaFlow.formatLabelsToStr(request);
        RateLimitWindowSet rateLimitWindowSet = this.getRateLimitWindowSet(serviceKey);
        RateLimitWindow rateLimitWindow = rateLimitWindowSet.getRateLimitWindow(rule, labelsStr);
        if (null != rateLimitWindow) {
            return rateLimitWindow;
        }
        return rateLimitWindowSet.addRateLimitWindow(request, labelsStr);
    }

    private RateLimitWindowSet getRateLimitWindowSet(ServiceKey serviceKey) {
        RateLimitWindowSet rateLimitWindowSet = this.svcToWindowSet.get(serviceKey);
        if (null != rateLimitWindowSet) {
            return rateLimitWindowSet;
        }
        return this.svcToWindowSet.computeIfAbsent(serviceKey, new Function<ServiceKey, RateLimitWindowSet>(){

            @Override
            public RateLimitWindowSet apply(ServiceKey serviceKey) {
                return new RateLimitWindowSet(serviceKey, QuotaFlow.this.rateLimitExtension, QuotaFlow.this.clientId);
            }
        });
    }

    private static String formatLabelsToStr(CommonQuotaRequest request) {
        RateLimitProto.Rule rule = request.getInitCriteria().getRule();
        Map<String, String> labels = request.getLabels();
        if (rule.getLabelsCount() == 0 || MapUtils.isEmpty(labels)) {
            return "";
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean regexCombine = rule.getRegexCombine().getValue();
        Map labelsMap = rule.getLabelsMap();
        for (Map.Entry entry : labelsMap.entrySet()) {
            String labelEntry;
            ModelProto.MatchString matcher = (ModelProto.MatchString)entry.getValue();
            if (matcher.getType() == ModelProto.MatchString.MatchStringType.REGEX && regexCombine) {
                labelEntry = (String)entry.getKey() + ":" + matcher.getValue().getValue();
            } else {
                labelEntry = (String)entry.getKey() + ":" + labels.get(entry.getKey());
                if (matcher.getType() == ModelProto.MatchString.MatchStringType.REGEX) {
                    request.setRegexSpread(true);
                }
            }
            tmpList.add(labelEntry);
        }
        Collections.sort(tmpList);
        return String.join((CharSequence)"|", tmpList);
    }

    private RateLimitProto.Rule lookupRule(ServiceRule serviceRule, Map<String, String> labels) {
        if (null == serviceRule.getRule()) {
            return null;
        }
        RateLimitProto.RateLimit rateLimitProto = (RateLimitProto.RateLimit)serviceRule.getRule();
        List rulesList = rateLimitProto.getRulesList();
        if (CollectionUtils.isEmpty((Collection)rulesList)) {
            return null;
        }
        for (RateLimitProto.Rule rule : rulesList) {
            if (null != rule.getDisable() && rule.getDisable().getValue() || rule.getAmountsCount() == 0) continue;
            if (rule.getLabelsCount() == 0) {
                return rule;
            }
            boolean allMatchLabels = true;
            Map labelsMap = rule.getLabelsMap();
            for (Map.Entry entry : labelsMap.entrySet()) {
                if (this.matchLabels((String)entry.getKey(), (ModelProto.MatchString)entry.getValue(), labels)) continue;
                allMatchLabels = false;
                break;
            }
            if (!allMatchLabels) continue;
            return rule;
        }
        return null;
    }

    private boolean matchLabels(String ruleLabelKey, ModelProto.MatchString ruleLabelMatch, Map<String, String> labels) {
        if (RuleUtils.isMatchAllValue((ModelProto.MatchString)ruleLabelMatch)) {
            return true;
        }
        if (MapUtils.isEmpty(labels)) {
            return false;
        }
        if (!labels.containsKey(ruleLabelKey)) {
            return false;
        }
        String labelValue = labels.get(ruleLabelKey);
        FlowCache flowCache = this.rateLimitExtension.getExtensions().getFlowCache();
        ModelProto.MatchString.MatchStringType matchType = ruleLabelMatch.getType();
        String matchValue = ruleLabelMatch.getValue().getValue();
        if (matchType == ModelProto.MatchString.MatchStringType.REGEX) {
            Pattern pattern = flowCache.loadOrStoreCompiledRegex(matchValue);
            return pattern.matcher(labelValue).find();
        }
        return StringUtils.equals((String)labelValue, (String)matchValue);
    }

    private static Map<String, RateLimitProto.Rule> parseRules(RegistryCacheValue oldValue) {
        if (null == oldValue || !oldValue.isInitialized()) {
            return null;
        }
        ServiceRule serviceRule = (ServiceRule)oldValue;
        if (null == serviceRule.getRule()) {
            return null;
        }
        HashMap<String, RateLimitProto.Rule> ruleMap = new HashMap<String, RateLimitProto.Rule>();
        RateLimitProto.RateLimit rateLimit = (RateLimitProto.RateLimit)serviceRule.getRule();
        for (RateLimitProto.Rule rule : rateLimit.getRulesList()) {
            ruleMap.put(rule.getRevision().getValue(), rule);
        }
        return ruleMap;
    }

    private void deleteRules(ServiceKey serviceKey, Set<String> deletedRules) {
        LOG.info("[RateLimit]start to delete rules {} for service {}", deletedRules, (Object)serviceKey);
        RateLimitWindowSet rateLimitWindowSet = this.svcToWindowSet.get(serviceKey);
        if (null == rateLimitWindowSet) {
            return;
        }
        rateLimitWindowSet.deleteRules(deletedRules);
    }

    private class RateLimitRuleListener
    extends AbstractResourceEventListener {
        private RateLimitRuleListener() {
        }

        public void onResourceUpdated(ServiceEventKey svcEventKey, RegistryCacheValue oldValue, RegistryCacheValue newValue) {
            ServiceEventKey.EventType eventType = svcEventKey.getEventType();
            if (eventType != ServiceEventKey.EventType.RATE_LIMITING) {
                return;
            }
            Map oldRules = QuotaFlow.parseRules(oldValue);
            Map newRules = QuotaFlow.parseRules(newValue);
            if (MapUtils.isEmpty((Map)oldRules)) {
                return;
            }
            HashSet deletedRules = new HashSet();
            for (Map.Entry entry : oldRules.entrySet()) {
                if (!MapUtils.isEmpty((Map)newRules) && newRules.containsKey(entry.getKey())) continue;
                deletedRules.add(entry.getKey());
            }
            if (CollectionUtils.isNotEmpty(deletedRules)) {
                QuotaFlow.this.deleteRules(svcEventKey.getServiceKey(), deletedRules);
            }
        }

        public void onResourceDeleted(ServiceEventKey svcEventKey, RegistryCacheValue oldValue) {
            ServiceEventKey.EventType eventType = svcEventKey.getEventType();
            if (eventType != ServiceEventKey.EventType.RATE_LIMITING) {
                return;
            }
            Map oldRules = QuotaFlow.parseRules(oldValue);
            if (MapUtils.isEmpty((Map)oldRules)) {
                return;
            }
            QuotaFlow.this.deleteRules(svcEventKey.getServiceKey(), oldRules.keySet());
        }
    }
}

