/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.pojo;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.plugin.ratelimiter.InitCriteria;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.ratelimit.api.rpc.QuotaRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CommonQuotaRequest
implements ServiceEventKeysProvider {
    private final ServiceEventKey svcEventKey;
    private final String method;
    private final Map<String, String> labels;
    private final int count;
    private ServiceRule rateLimitRule;
    private final InitCriteria initCriteria;
    private boolean regexSpread;
    private final FlowControlParam flowControlParam;

    public CommonQuotaRequest(QuotaRequest quotaRequest, Configuration configuration) {
        this.svcEventKey = new ServiceEventKey(new ServiceKey(quotaRequest.getNamespace(), quotaRequest.getService()), ServiceEventKey.EventType.RATE_LIMITING);
        this.labels = null == quotaRequest.getLabels() ? new HashMap<String, String>() : quotaRequest.getLabels();
        this.method = quotaRequest.getMethod();
        if (StringUtils.isNotBlank((String)this.method)) {
            this.labels.put("method", this.method);
        }
        this.count = quotaRequest.getCount();
        this.initCriteria = new InitCriteria();
        this.flowControlParam = new DefaultFlowControlParam();
        BaseFlow.buildFlowControlParam((RequestBaseEntity)quotaRequest, (Configuration)configuration, (FlowControlParam)this.flowControlParam);
    }

    public void setRateLimitRule(ServiceRule rateLimitRule) {
        this.rateLimitRule = rateLimitRule;
    }

    public void setRegexSpread(boolean regexSpread) {
        this.regexSpread = regexSpread;
    }

    public boolean isRegexSpread() {
        return this.regexSpread;
    }

    public void setTargetRule(RateLimitProto.Rule targetRule) {
        this.initCriteria.setRule(targetRule);
    }

    public boolean isUseCache() {
        return false;
    }

    public Set<ServiceEventKey> getSvcEventKeys() {
        return null;
    }

    public ServiceEventKey getSvcEventKey() {
        return this.svcEventKey;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public ServiceRule getRateLimitRule() {
        return this.rateLimitRule;
    }

    public InitCriteria getInitCriteria() {
        return this.initCriteria;
    }

    public FlowControlParam getFlowControlParam() {
        return this.flowControlParam;
    }

    public int getCount() {
        return this.count;
    }
}

