/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.config.provider.RateLimitConfig;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.AsyncRateLimitConnector;
import com.tencent.polaris.ratelimit.client.flow.RateLimitExtension;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import com.tencent.polaris.ratelimit.client.flow.WindowContainer;
import com.tencent.polaris.ratelimit.client.pojo.CommonQuotaRequest;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;

public class RateLimitWindowSet {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitWindowSet.class);
    private final ServiceKey serviceKey;
    private final RateLimitExtension rateLimitExtension;
    private final Map<String, WindowContainer> windowByRule = new ConcurrentHashMap<String, WindowContainer>();
    AsyncRateLimitConnector asyncRateLimitConnector;
    String clientId;

    public RateLimitWindowSet(ServiceKey serviceKey, RateLimitExtension rateLimitExtension, String clientId) {
        this.clientId = clientId;
        this.serviceKey = serviceKey;
        this.rateLimitExtension = rateLimitExtension;
        this.asyncRateLimitConnector = new AsyncRateLimitConnector();
    }

    public RateLimitWindow getRateLimitWindow(RateLimitProto.Rule rule, String labelsStr) {
        WindowContainer windowContainer = this.windowByRule.get(rule.getRevision().getValue());
        if (null == windowContainer) {
            return null;
        }
        return windowContainer.getLabelWindow(labelsStr);
    }

    public RateLimitWindow addRateLimitWindow(final CommonQuotaRequest request, String labelsStr, final RateLimitConfig rateLimitConfig) {
        Function<String, RateLimitWindow> createRateLimitWindow;
        RateLimitProto.Rule targetRule = request.getInitCriteria().getRule();
        String revision = targetRule.getRevision().getValue();
        WindowContainer container = this.windowByRule.computeIfAbsent(revision, new Function<String, WindowContainer>((Function)(createRateLimitWindow = new Function<String, RateLimitWindow>(){

            @Override
            public RateLimitWindow apply(String label) {
                return new RateLimitWindow(RateLimitWindowSet.this, request, label, rateLimitConfig);
            }
        }), labelsStr, request){
            final /* synthetic */ Function val$createRateLimitWindow;
            final /* synthetic */ String val$labelsStr;
            final /* synthetic */ CommonQuotaRequest val$request;
            {
                this.val$createRateLimitWindow = function;
                this.val$labelsStr = string;
                this.val$request = commonQuotaRequest;
            }

            @Override
            public WindowContainer apply(String s) {
                RateLimitWindow window = (RateLimitWindow)this.val$createRateLimitWindow.apply(this.val$labelsStr);
                return new WindowContainer(RateLimitWindowSet.this.serviceKey, this.val$labelsStr, window, this.val$request.isRegexSpread());
            }
        });
        RateLimitWindow mainWindow = container.getLabelWindow(labelsStr);
        if (null != mainWindow) {
            return mainWindow;
        }
        return container.computeLabelWindow(labelsStr, createRateLimitWindow);
    }

    public RateLimitExtension getRateLimitExtension() {
        return this.rateLimitExtension;
    }

    public void deleteRules(Set<String> rules) {
        for (String rule : rules) {
            WindowContainer container = this.windowByRule.remove(rule);
            if (null == container) continue;
            LOG.info("[RateLimit]container {} for service {} has been stopped", (Object)rule, (Object)this.serviceKey);
            container.stopSyncTasks();
        }
    }

    public void cleanupContainers() {
        int rulesExpired = 0;
        for (Map.Entry<String, WindowContainer> entry : this.windowByRule.entrySet()) {
            String revision = entry.getKey();
            boolean expired = entry.getValue().checkAndExpireWindows();
            if (!expired) continue;
            ++rulesExpired;
            WindowContainer container = this.windowByRule.remove(revision);
            if (null == container) continue;
            container.getMainWindow().unInit();
        }
        if (rulesExpired > 0) {
            LOG.info("[RateLimit]{} rules has been cleanup by expired, service {}", (Object)rulesExpired, (Object)this.serviceKey);
        }
    }

    public AsyncRateLimitConnector getAsyncRateLimitConnector() {
        return this.asyncRateLimitConnector;
    }

    public String getClientId() {
        return this.clientId;
    }
}

