/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;

public class WindowContainer {
    private static final Logger LOG = LoggerFactory.getLogger(WindowContainer.class);
    private final ServiceKey serviceKey;
    private final RateLimitWindow mainWindow;
    private final Map<String, RateLimitWindow> windowByLabel;

    public WindowContainer(ServiceKey serviceKey, String labelStr, RateLimitWindow window, boolean regexSpread) {
        this.serviceKey = serviceKey;
        if (!regexSpread) {
            this.mainWindow = window;
            this.windowByLabel = null;
        } else {
            this.mainWindow = null;
            this.windowByLabel = new ConcurrentHashMap<String, RateLimitWindow>();
            this.windowByLabel.put(labelStr, window);
        }
    }

    public RateLimitWindow getLabelWindow(String label) {
        if (null != this.mainWindow) {
            return this.mainWindow;
        }
        return this.windowByLabel.get(label);
    }

    public RateLimitWindow computeLabelWindow(String label, Function<String, RateLimitWindow> function) {
        return this.windowByLabel.computeIfAbsent(label, function);
    }

    public void stopSyncTasks() {
        if (null != this.mainWindow) {
            this.mainWindow.unInit();
            return;
        }
        for (RateLimitWindow window : this.windowByLabel.values()) {
            window.unInit();
        }
    }

    public RateLimitWindow getMainWindow() {
        return this.mainWindow;
    }

    public boolean checkAndExpireWindows() {
        if (null != this.mainWindow) {
            return this.mainWindow.isExpired();
        }
        int expiredLabels = 0;
        for (Map.Entry<String, RateLimitWindow> entry : this.windowByLabel.entrySet()) {
            String labelKey = entry.getKey();
            RateLimitWindow window = entry.getValue();
            if (!window.isExpired()) continue;
            ++expiredLabels;
            window = this.windowByLabel.remove(labelKey);
            if (null == window) continue;
            window.unInit();
        }
        if (expiredLabels > 0) {
            LOG.info("[RateLimit]{} labels has been cleanup by expired, service {}", (Object)expiredLabels, (Object)this.serviceKey);
        }
        return false;
    }
}

