/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.router.api.rpc;

import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.MapUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessRoutersRequest
extends RequestBaseEntity {
    private ServiceInfo sourceService;
    private RouterNamesGroup routers;
    private ServiceInstances dstInstances;
    private String method;
    private Map<String, Map<String, String>> routerMetadata;
    private MetadataFailoverType metadataFailoverType;

    public ServiceInfo getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ServiceInfo sourceService) {
        this.sourceService = sourceService;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public RouterNamesGroup getRouters() {
        return this.routers;
    }

    public void setRouters(RouterNamesGroup routers) {
        this.routers = routers;
    }

    public ServiceInstances getDstInstances() {
        return this.dstInstances;
    }

    public void setDstInstances(ServiceInstances dstInstances) {
        this.dstInstances = dstInstances;
    }

    public void putRouterMetadata(String routerType, Map<String, String> metadata) {
        if (MapUtils.isEmpty(metadata)) {
            return;
        }
        if (this.routerMetadata == null) {
            this.routerMetadata = new HashMap<String, Map<String, String>>();
        }
        this.routerMetadata.put(routerType, metadata);
    }

    public void addRouterMetadata(String routerType, Map<String, String> metadata) {
        if (MapUtils.isEmpty(metadata)) {
            return;
        }
        if (this.routerMetadata == null) {
            this.routerMetadata = new HashMap<String, Map<String, String>>();
        }
        Map subRouterMetadata = this.routerMetadata.computeIfAbsent(routerType, k -> new HashMap());
        subRouterMetadata.putAll(metadata);
    }

    public Map<String, String> getRouterMetadata(String routerType) {
        if (this.routerMetadata == null) {
            return Collections.emptyMap();
        }
        Map<String, String> metadata = this.routerMetadata.get(routerType);
        if (metadata == null || metadata.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(metadata);
    }

    public Map<String, Map<String, String>> getRouterMetadata() {
        return this.routerMetadata;
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    public static class RouterNamesGroup {
        private List<String> beforeRouters;
        private List<String> coreRouters;
        private List<String> afterRouters;

        public List<String> getBeforeRouters() {
            return this.beforeRouters;
        }

        public void setBeforeRouters(List<String> beforeRouters) {
            this.beforeRouters = beforeRouters;
        }

        public List<String> getCoreRouters() {
            return this.coreRouters;
        }

        public void setCoreRouters(List<String> coreRouters) {
            this.coreRouters = coreRouters;
        }

        public List<String> getAfterRouters() {
            return this.afterRouters;
        }

        public void setAfterRouters(List<String> afterRouters) {
            this.afterRouters = afterRouters;
        }
    }
}

