/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.router.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.DefaultRouterChainGroup;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.router.api.core.RouterAPI;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceRequest;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceResponse;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import com.tencent.polaris.router.api.rpc.ProcessRoutersResponse;
import com.tencent.polaris.router.client.util.RouterValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DefaultRouterAPI
extends BaseEngine
implements RouterAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRouterAPI.class);
    private final Configuration config;
    private final Extensions extensions;

    public DefaultRouterAPI(SDKContext context) {
        super(context);
        this.extensions = context.getExtensions();
        this.config = context.getConfig();
    }

    protected void subInit() {
    }

    public ProcessRoutersResponse processRouters(ProcessRoutersRequest request) throws PolarisException {
        this.checkAvailable("RouterAPI");
        RouterValidator.validateProcessRouterRequest(request);
        ProcessRoutersRequest.RouterNamesGroup requestRouterGroup = request.getRouters();
        List beforeRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty((Collection)requestRouterGroup.getBeforeRouters()) ? Extensions.loadServiceRouters((List)requestRouterGroup.getBeforeRouters(), (Supplier)this.extensions.getPlugins(), (boolean)true) : this.extensions.getConfigRouterChainGroup().getBeforeRouters();
        List afterRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty((Collection)requestRouterGroup.getAfterRouters()) ? Extensions.loadServiceRouters((List)requestRouterGroup.getAfterRouters(), (Supplier)this.extensions.getPlugins(), (boolean)true) : this.extensions.getConfigRouterChainGroup().getAfterRouters();
        List coreRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty((Collection)requestRouterGroup.getCoreRouters()) ? Extensions.loadServiceRouters((List)requestRouterGroup.getCoreRouters(), (Supplier)this.extensions.getPlugins(), (boolean)true) : this.extensions.getConfigRouterChainGroup().getCoreRouters();
        ServiceInstances dstInstances = request.getDstInstances();
        RouteInfo routeInfo = new RouteInfo((ServiceMetadata)request.getSourceService(), (ServiceMetadata)dstInstances, request.getMethod());
        DefaultFlowControlParam engineFlowControlParam = new DefaultFlowControlParam();
        BaseFlow.buildFlowControlParam((RequestBaseEntity)request, (Configuration)this.config, (FlowControlParam)engineFlowControlParam);
        HashSet<ServiceEventKey> routerKeys = new HashSet<ServiceEventKey>();
        ServiceEventKey dstSvcEventKey = new ServiceEventKey(new ServiceKey(dstInstances.getNamespace(), dstInstances.getService()), ServiceEventKey.EventType.ROUTING);
        routerKeys.add(dstSvcEventKey);
        ServiceEventKey srcSvcEventKey = null;
        if (null != routeInfo.getSourceService() && StringUtils.isNotBlank((String)routeInfo.getSourceService().getNamespace()) && StringUtils.isNotBlank((String)routeInfo.getSourceService().getService())) {
            srcSvcEventKey = new ServiceEventKey(new ServiceKey(routeInfo.getSourceService().getNamespace(), routeInfo.getSourceService().getService()), ServiceEventKey.EventType.ROUTING);
            routerKeys.add(srcSvcEventKey);
        }
        DefaultServiceEventKeysProvider svcKeysProvider = new DefaultServiceEventKeysProvider();
        svcKeysProvider.setSvcEventKeys(routerKeys);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)svcKeysProvider, (FlowControlParam)engineFlowControlParam);
        routeInfo.setDestRouteRule(resourcesResponse.getServiceRule(dstSvcEventKey));
        if (null != srcSvcEventKey) {
            routeInfo.setSourceRouteRule(resourcesResponse.getServiceRule(srcSvcEventKey));
        }
        DefaultRouterChainGroup routerChainGroup = new DefaultRouterChainGroup(beforeRouters, coreRouters, afterRouters);
        ServiceInstances svcInstances = BaseFlow.processServiceRouters((RouteInfo)routeInfo, (ServiceInstances)dstInstances, (RouterChainGroup)routerChainGroup);
        return new ProcessRoutersResponse(svcInstances);
    }

    public ProcessLoadBalanceResponse processLoadBalance(ProcessLoadBalanceRequest request) throws PolarisException {
        this.checkAvailable("EngineAPI");
        RouterValidator.validateProcessLoadBalanceRequest(request);
        String lbPolicy = request.getLbPolicy();
        if (StringUtils.isBlank((String)lbPolicy)) {
            lbPolicy = this.extensions.getConfiguration().getConsumer().getLoadbalancer().getType();
        }
        LoadBalancer loadBalancer = (LoadBalancer)this.extensions.getPlugins().getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), lbPolicy);
        Instance instance = BaseFlow.processLoadBalance((LoadBalancer)loadBalancer, (Criteria)request.getCriteria(), (ServiceInstances)request.getDstInstances());
        return new ProcessLoadBalanceResponse(instance);
    }
}

