/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.test.mock.discovery;

import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.test.mock.discovery.HeaderInterceptor;
import com.tencent.polaris.test.mock.discovery.NamingService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;

public class NamingServer {
    private static final Logger LOG = LoggerFactory.getLogger(NamingServer.class);
    private static final int MIN_RANDOM_PORT = 20000;
    private static final int MAX_RANDOM_PORT = 65535;
    private final Server server;
    private final int port;
    private final NamingService namingService = new NamingService();

    public NamingServer(int port) {
        this.server = ServerBuilder.forPort((int)port).addService(ServerInterceptors.intercept((BindableService)this.namingService, (ServerInterceptor[])new ServerInterceptor[]{new HeaderInterceptor()})).build();
        this.port = port;
    }

    public static NamingServer startNamingServer(int port) throws IOException {
        if (port <= 0) {
            port = NamingServer.selectRandomPort();
        }
        NamingServer namingServer = new NamingServer(port);
        namingServer.start();
        Node node = new Node("127.0.0.1", port);
        NamingService.InstanceParameter parameter = new NamingService.InstanceParameter();
        parameter.setHealthy(true);
        parameter.setIsolated(false);
        parameter.setProtocol("grpc");
        parameter.setWeight(100);
        namingServer.getNamingService().addInstance(new ServiceKey("Polaris", "polaris.discover"), node, parameter);
        namingServer.getNamingService().addInstance(new ServiceKey("Polaris", "polaris.healthcheck"), node, parameter);
        return namingServer;
    }

    public static int selectRandomPort() {
        int randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
        while (!NamingServer.isPortAvailable(randomPort)) {
            randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
        }
        return randomPort;
    }

    private static boolean isPortAvailable(int port) {
        try {
            NamingServer.bindPort("0.0.0.0", port);
            NamingServer.bindPort(InetAddress.getLocalHost().getHostAddress(), port);
            NamingServer.bindPort(InetAddress.getLoopbackAddress().getHostAddress(), port);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void bindPort(String host, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.bind(new InetSocketAddress(host, port));
        }
    }

    public void start() throws IOException {
        this.server.start();
        LOG.info(String.format("server start listening on %d", this.port));
    }

    public int getPort() {
        return this.port;
    }

    public void terminate() {
        this.server.shutdown();
    }

    public NamingService getNamingService() {
        return this.namingService;
    }
}

