/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.test.mock.discovery;

import com.google.protobuf.BoolValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import com.tencent.polaris.specification.api.v1.service.manage.PolarisGRPCGrpc;
import com.tencent.polaris.specification.api.v1.service.manage.RequestProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import com.tencent.polaris.test.mock.discovery.LocationInfo;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class NamingService
extends PolarisGRPCGrpc.PolarisGRPCImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(NamingService.class);
    private final Map<ServiceKey, List<ServiceProto.Instance>> services = new ConcurrentHashMap<ServiceKey, List<ServiceProto.Instance>>();
    private final Map<ServiceKey, RoutingProto.Routing> serviceRoutings = new ConcurrentHashMap<ServiceKey, RoutingProto.Routing>();
    private final Map<ServiceKey, CircuitBreakerProto.CircuitBreaker> serviceCircuitBreakers = new ConcurrentHashMap<ServiceKey, CircuitBreakerProto.CircuitBreaker>();
    private final Map<ServiceKey, RateLimitProto.RateLimit> serviceRateLimits = new ConcurrentHashMap<ServiceKey, RateLimitProto.RateLimit>();

    public void addService(ServiceKey serviceKey) {
        this.services.put(serviceKey, new ArrayList());
    }

    public void setRouting(ServiceKey serviceKey, RoutingProto.Routing routing) {
        this.serviceRoutings.put(serviceKey, routing);
    }

    public void setCircuitBreaker(ServiceKey serviceKey, CircuitBreakerProto.CircuitBreaker circuitBreaker) {
        this.serviceCircuitBreakers.put(serviceKey, circuitBreaker);
    }

    public void setRateLimit(ServiceKey serviceKey, RateLimitProto.RateLimit rateLimit) {
        this.serviceRateLimits.put(serviceKey, rateLimit);
    }

    private ServiceProto.Instance buildInstance(ServiceKey svcKey, Node node, InstanceParameter parameter) {
        Map<String, String> metadata;
        ServiceProto.Instance.Builder builder = ServiceProto.Instance.newBuilder();
        String instId = UUID.randomUUID().toString();
        builder.setId(StringValue.newBuilder().setValue(instId).build());
        builder.setNamespace(StringValue.newBuilder().setValue(svcKey.getNamespace()).build());
        builder.setService(StringValue.newBuilder().setValue(svcKey.getService()).build());
        builder.setHost(StringValue.newBuilder().setValue(node.getHost()).build());
        builder.setPort(UInt32Value.newBuilder().setValue(node.getPort()).build());
        builder.setHealthy(BoolValue.newBuilder().setValue(parameter.isHealthy()).build());
        builder.setIsolate(BoolValue.newBuilder().setValue(parameter.isIsolated()).build());
        if (StringUtils.isNotBlank((String)parameter.getProtocol())) {
            builder.setProtocol(StringValue.newBuilder().setValue(parameter.getProtocol()).build());
            builder.putMetadata("protocol", parameter.getProtocol());
        }
        if (StringUtils.isNotBlank((String)parameter.getVersion())) {
            builder.setVersion(StringValue.newBuilder().setValue(parameter.getVersion()).build());
            builder.putMetadata("version", parameter.getVersion());
        }
        builder.setWeight(UInt32Value.newBuilder().setValue(parameter.getWeight()).build());
        LocationInfo locationInfo = parameter.getLocationInfo();
        if (null != locationInfo) {
            ModelProto.Location.Builder locationBuilder = ModelProto.Location.newBuilder();
            locationBuilder.setRegion(StringValue.newBuilder().setValue(locationInfo.getRegion()).build());
            locationBuilder.setZone(StringValue.newBuilder().setValue(locationInfo.getZone()).build());
            locationBuilder.setCampus(StringValue.newBuilder().setValue(locationInfo.getCampus()).build());
            builder.setLocation(locationBuilder.build());
        }
        if (null != (metadata = parameter.getMetadata())) {
            builder.putAllMetadata(metadata);
        }
        return builder.build();
    }

    public void addInstance(ServiceKey svcKey, Node node, InstanceParameter parameter) {
        ServiceProto.Instance instance = this.buildInstance(svcKey, node, parameter);
        List<ServiceProto.Instance> existsInstances = this.services.get(svcKey);
        if (null == existsInstances) {
            ArrayList<ServiceProto.Instance> instances = new ArrayList<ServiceProto.Instance>();
            instances.add(instance);
            this.services.put(svcKey, instances);
        } else {
            existsInstances.add(instance);
        }
    }

    public List<Node> batchAddInstances(ServiceKey svcKey, int portStart, int instCount, InstanceParameter parameter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<ServiceProto.Instance> instances = new ArrayList<ServiceProto.Instance>();
        for (int i = 0; i < instCount; ++i) {
            Node node = new Node("127.0.0.1", portStart + i);
            ServiceProto.Instance nextInstance = this.buildInstance(svcKey, node, parameter);
            instances.add(nextInstance);
            nodes.add(node);
        }
        List<ServiceProto.Instance> existsInstances = this.services.get(svcKey);
        if (null == existsInstances) {
            this.services.put(svcKey, instances);
        } else {
            existsInstances.addAll(instances);
        }
        return nodes;
    }

    public void setInstanceHealthyStatus(ServiceKey svcKey, Node node, Boolean healthyStatus, Boolean isolated, Integer weight) {
        List<ServiceProto.Instance> instances = this.services.get(svcKey);
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        ArrayList newInstances = new ArrayList();
        instances.forEach(instance -> {
            if (StringUtils.equals((String)node.getHost(), (String)instance.getHost().getValue()) && node.getPort() == instance.getPort().getValue()) {
                ServiceProto.Instance.Builder builder = instance.toBuilder();
                if (null != healthyStatus) {
                    builder.setHealthy(BoolValue.newBuilder().setValue(healthyStatus.booleanValue()));
                }
                if (null != isolated) {
                    builder.setIsolate(BoolValue.newBuilder().setValue(isolated.booleanValue()).build());
                }
                if (null != weight) {
                    builder.setWeight(UInt32Value.newBuilder().setValue(weight.intValue()).build());
                }
                newInstances.add(builder.build());
            } else {
                newInstances.add(instance);
            }
        });
        this.services.put(svcKey, newInstances);
    }

    public void registerInstance(ServiceProto.Instance request, StreamObserver<ResponseProto.Response> responseObserver) {
        List<ServiceProto.Instance> instances;
        ServiceKey serviceKey = new ServiceKey(request.getNamespace().getValue(), request.getService().getValue());
        if (!this.services.containsKey(serviceKey)) {
            this.services.put(serviceKey, new ArrayList());
        }
        if (CollectionUtils.isNotEmpty(instances = this.services.get(serviceKey))) {
            for (ServiceProto.Instance instance : instances) {
                if (!instance.getHost().getValue().equals(request.getHost().getValue()) || instance.getPort().getValue() != request.getPort().getValue()) continue;
                responseObserver.onNext((Object)this.buildResponse(400201, String.format("instance %s:%d exists", request.getHost().getValue(), request.getPort().getValue()), instance));
                responseObserver.onCompleted();
                return;
            }
        }
        ServiceProto.Instance.Builder builder = ServiceProto.Instance.newBuilder();
        builder.mergeFrom(request);
        String instId = UUID.randomUUID().toString();
        builder.setId(StringValue.newBuilder().setValue(instId).build());
        ServiceProto.Instance nextInstance = builder.build();
        instances.add(nextInstance);
        ResponseProto.Response.Builder response = ResponseProto.Response.newBuilder();
        response.setCode(UInt32Value.newBuilder().setValue(200000).build());
        response.setInstance(nextInstance);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    private ResponseProto.Response buildResponse(int code, String info, ServiceProto.Instance instance) {
        ResponseProto.Response.Builder response = ResponseProto.Response.newBuilder();
        response.setCode(UInt32Value.newBuilder().setValue(code).build());
        if (StringUtils.isNotBlank((String)info)) {
            response.setInfo(StringValue.newBuilder().setValue(info).build());
        }
        if (null != instance) {
            response.setInstance(instance);
        }
        return response.build();
    }

    public void deregisterInstance(ServiceProto.Instance request, StreamObserver<ResponseProto.Response> responseObserver) {
        ServiceKey serviceKey = new ServiceKey(request.getNamespace().getValue(), request.getService().getValue());
        if (!this.services.containsKey(serviceKey)) {
            responseObserver.onNext((Object)this.buildResponse(400202, String.format("service %s not found", serviceKey), request));
            responseObserver.onCompleted();
            return;
        }
        int rIndex = -1;
        List<ServiceProto.Instance> instances = this.services.get(serviceKey);
        for (int i = 0; i < instances.size(); ++i) {
            ServiceProto.Instance instance = instances.get(i);
            if (StringUtils.isNotBlank((String)request.getId().getValue())) {
                if (!StringUtils.equals((String)request.getId().getValue(), (String)request.getId().getValue())) continue;
                rIndex = i;
                break;
            }
            if (!StringUtils.equals((String)request.getHost().getValue(), (String)instance.getHost().getValue()) || request.getPort().getValue() != instance.getPort().getValue()) continue;
            rIndex = i;
            break;
        }
        if (rIndex != -1) {
            instances.remove(rIndex);
        }
        if (CollectionUtils.isEmpty(instances)) {
            this.services.remove(serviceKey);
        }
        ResponseProto.Response.Builder response = ResponseProto.Response.newBuilder();
        response.setCode(UInt32Value.newBuilder().setValue(200000).build());
        response.setInstance(request);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void heartbeat(ServiceProto.Instance request, StreamObserver<ResponseProto.Response> responseObserver) {
        ServiceKey serviceKey = new ServiceKey(request.getNamespace().getValue(), request.getService().getValue());
        if (!this.services.containsKey(serviceKey)) {
            responseObserver.onNext((Object)this.buildResponse(400202, String.format("service %s not found", serviceKey), request));
            responseObserver.onCompleted();
            return;
        }
        ResponseProto.Response.Builder response = ResponseProto.Response.newBuilder();
        response.setCode(UInt32Value.newBuilder().setValue(200000).build());
        response.setInstance(request);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    private ResponseProto.DiscoverResponse buildServiceResponse(int code, String info, RequestProto.DiscoverRequest req) {
        ResponseProto.DiscoverResponse.Builder builder = ResponseProto.DiscoverResponse.newBuilder();
        builder.setCode(UInt32Value.newBuilder().setValue(code).build());
        ServiceProto.Service service = req.getService();
        ServiceKey serviceKey = new ServiceKey(service.getNamespace().getValue(), service.getName().getValue());
        switch (req.getType()) {
            case UNKNOWN: {
                break;
            }
            case INSTANCE: {
                List<ServiceProto.Instance> instances = this.services.get(serviceKey);
                if (CollectionUtils.isNotEmpty(instances)) {
                    builder.addAllInstances(instances);
                    service = service.toBuilder().setRevision(StringValue.of((String)UUID.randomUUID().toString())).build();
                }
                builder.setType(ResponseProto.DiscoverResponse.DiscoverResponseType.INSTANCE);
                break;
            }
            case CLUSTER: {
                break;
            }
            case ROUTING: {
                RoutingProto.Routing routing = this.serviceRoutings.get(serviceKey);
                if (null != routing) {
                    builder.setRouting(routing);
                    service = service.toBuilder().setRevision(StringValue.of((String)UUID.randomUUID().toString())).build();
                }
                builder.setType(ResponseProto.DiscoverResponse.DiscoverResponseType.ROUTING);
                break;
            }
            case CIRCUIT_BREAKER: {
                CircuitBreakerProto.CircuitBreaker circuitBreaker = this.serviceCircuitBreakers.get(serviceKey);
                if (null != circuitBreaker) {
                    builder.setCircuitBreaker(circuitBreaker);
                    service = service.toBuilder().setRevision(StringValue.of((String)UUID.randomUUID().toString())).build();
                }
                builder.setType(ResponseProto.DiscoverResponse.DiscoverResponseType.CIRCUIT_BREAKER);
                break;
            }
            case RATE_LIMIT: {
                RateLimitProto.RateLimit rateLimit = this.serviceRateLimits.get(serviceKey);
                if (null != rateLimit) {
                    builder.setRateLimit(rateLimit);
                    service = service.toBuilder().setRevision(StringValue.of((String)UUID.randomUUID().toString())).build();
                }
                builder.setType(ResponseProto.DiscoverResponse.DiscoverResponseType.RATE_LIMIT);
                break;
            }
            case SERVICES: {
                Set<ServiceKey> keys = this.services.keySet();
                HashMap<String, ServiceProto.Service> tmp = new HashMap<String, ServiceProto.Service>();
                String namespace = req.getService().getNamespace().getValue();
                System.out.println("get service param : " + namespace);
                keys.removeIf(serviceKey1 -> {
                    if (StringUtils.isBlank((String)namespace)) {
                        return false;
                    }
                    return !Objects.equals(namespace, serviceKey1.getNamespace());
                });
                keys.forEach(key -> tmp.put(key.getNamespace() + "##" + key.getService(), ServiceProto.Service.newBuilder().setNamespace(StringValue.newBuilder().setValue(key.getNamespace()).build()).setName(StringValue.newBuilder().setValue(key.getService()).build()).build()));
                int[] index = new int[]{0};
                tmp.forEach((s, svc) -> {
                    builder.addServices(index[0], svc);
                    index[0] = index[0] + 1;
                });
                builder.setType(ResponseProto.DiscoverResponse.DiscoverResponseType.SERVICES);
                break;
            }
            case UNRECOGNIZED: {
                break;
            }
        }
        if (StringUtils.isNotBlank((String)info)) {
            builder.setInfo(StringValue.newBuilder().setValue(info).build());
        }
        builder.setService(service);
        return builder.build();
    }

    public StreamObserver<RequestProto.DiscoverRequest> discover(final StreamObserver<ResponseProto.DiscoverResponse> responseObserver) {
        return new StreamObserver<RequestProto.DiscoverRequest>(){

            public void onNext(RequestProto.DiscoverRequest req) {
                if (req.getType().equals((Object)RequestProto.DiscoverRequest.DiscoverRequestType.INSTANCE)) {
                    ServiceProto.Service service = req.getService();
                    ServiceKey serviceKey = new ServiceKey(service.getNamespace().getValue(), service.getName().getValue());
                    if (!NamingService.this.services.containsKey(serviceKey)) {
                        responseObserver.onNext((Object)NamingService.this.buildServiceResponse(400202, String.format("service %s not found", serviceKey), req));
                        return;
                    }
                }
                responseObserver.onNext((Object)NamingService.this.buildServiceResponse(200000, "", req));
            }

            public void onError(Throwable t) {
                LOG.error("receive client error", t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    public static class InstanceParameter {
        private boolean healthy;
        private boolean isolated;
        private int weight;
        private String protocol;
        private String version;
        private LocationInfo locationInfo;
        private Map<String, String> metadata;

        public boolean isHealthy() {
            return this.healthy;
        }

        public void setHealthy(boolean healthy) {
            this.healthy = healthy;
        }

        public boolean isIsolated() {
            return this.isolated;
        }

        public void setIsolated(boolean isolated) {
            this.isolated = isolated;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public LocationInfo getLocationInfo() {
            return this.locationInfo;
        }

        public void setLocationInfo(LocationInfo locationInfo) {
            this.locationInfo = locationInfo;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }
    }
}

