/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.threadlocal.cross;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CallableWrapper<U, T>
implements Callable<U> {
    private final Callable<U> callable;
    private final AtomicReference<T> contextRef;
    private final Supplier<T> contextGetter;
    private final Consumer<T> contextSetter;

    public CallableWrapper(Callable<U> callable, Supplier<T> contextGetter, Consumer<T> contextSetter) {
        assert (null != callable && null != contextGetter && null != contextSetter);
        this.callable = callable;
        this.contextGetter = contextGetter;
        this.contextSetter = contextSetter;
        this.contextRef = new AtomicReference<T>(contextGetter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U call() throws Exception {
        T latestContext = this.contextGetter.get();
        T contextValue = this.contextRef.get();
        this.contextSetter.accept(contextValue);
        try {
            U u = this.callable.call();
            return u;
        }
        finally {
            this.contextSetter.accept(latestContext);
        }
    }
}

