/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.threadlocal.cross;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RunnableWrapper<T>
implements Runnable {
    private final Runnable runnable;
    private final AtomicReference<T> contextRef;
    private final Supplier<T> contextGetter;
    private final Consumer<T> contextSetter;

    public RunnableWrapper(Runnable runnable, Supplier<T> contextGetter, Consumer<T> contextSetter) {
        assert (null != runnable && null != contextGetter && null != contextSetter);
        this.runnable = runnable;
        this.contextGetter = contextGetter;
        this.contextSetter = contextSetter;
        this.contextRef = new AtomicReference<T>(contextGetter.get());
    }

    @Override
    public void run() {
        T latestContext = this.contextGetter.get();
        T contextValue = this.contextRef.get();
        this.contextSetter.accept(contextValue);
        try {
            this.runnable.run();
        }
        finally {
            this.contextSetter.accept(latestContext);
        }
    }
}

