/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.threadlocal.cross;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SupplierWrapper<U, T>
implements Supplier<U> {
    private final Supplier<U> supplier;
    private final AtomicReference<T> contextRef;
    private final Supplier<T> contextGetter;
    private final Consumer<T> contextSetter;

    public SupplierWrapper(Supplier<U> supplier, Supplier<T> contextGetter, Consumer<T> contextSetter) {
        assert (null != supplier && null != contextGetter && null != contextSetter);
        this.supplier = supplier;
        this.contextGetter = contextGetter;
        this.contextSetter = contextSetter;
        this.contextRef = new AtomicReference<T>(contextGetter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U get() {
        T latestContext = this.contextGetter.get();
        T contextValue = this.contextRef.get();
        this.contextSetter.accept(contextValue);
        try {
            U u = this.supplier.get();
            return u;
        }
        finally {
            this.contextSetter.accept(latestContext);
        }
    }
}

