/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.common.slide;

import com.tencent.polaris.plugins.ratelimiter.common.slide.Window;

public class SlidingWindow {
    private final long windowLengthMs;
    private final Object lock = new Object();
    private final Window[] windowArray;
    private final int slideCount;

    public SlidingWindow(int slideCount, long intervalMs) {
        this.slideCount = slideCount;
        this.windowLengthMs = intervalMs / (long)slideCount;
        this.windowArray = new Window[slideCount];
        for (int i = 0; i < slideCount; ++i) {
            this.windowArray[i] = new Window();
        }
    }

    private int calculateTimeIdx(long curTimeMs) {
        long timeId = curTimeMs / this.windowLengthMs;
        return (int)(timeId % (long)this.slideCount);
    }

    public static long calculateStartTimeMs(long curTimeMs, long intervalMs) {
        return curTimeMs - curTimeMs % intervalMs;
    }

    private long calculateWindowStartMs(long curTimeMs) {
        return SlidingWindow.calculateStartTimeMs(curTimeMs, this.windowLengthMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window currentWindow(long curTimeMs) {
        int idx = this.calculateTimeIdx(curTimeMs);
        long windowStartMs = this.calculateWindowStartMs(curTimeMs);
        Window curWindow = this.windowArray[idx];
        long oldWindowStartMs = curWindow.getCurrentWindowStartMs();
        if (oldWindowStartMs == windowStartMs) {
            return curWindow;
        }
        Object object = this.lock;
        synchronized (object) {
            curWindow.reset(oldWindowStartMs, windowStartMs);
            return curWindow;
        }
    }

    public void addAndGetCurrentPassed(long curTimeMs, long value) {
        Window curWindow = this.currentWindow(curTimeMs);
        curWindow.addAndGetPassed(value);
    }

    public void addAndGetCurrentLimited(long curTimeMs, long value) {
        Window curWindow = this.currentWindow(curTimeMs);
        curWindow.addAndGetLimited(value);
    }

    public Result acquireCurrentValues(long curTimeMs) {
        Window curWindow = this.currentWindow(curTimeMs);
        return new Result(curWindow.swapPassed(), curWindow.swapLimited());
    }

    public long touchCurrentPassed(long curTimeMs) {
        Window curWindow = this.currentWindow(curTimeMs);
        return curWindow.getPassedValue();
    }

    public static class Result {
        private final long passed;
        private final long limited;

        public Result(long passed, long limited) {
            this.passed = passed;
            this.limited = limited;
        }

        public long getPassed() {
            return this.passed;
        }

        public long getLimited() {
            return this.limited;
        }
    }
}

