/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.reject;

import com.tencent.polaris.api.plugin.ratelimiter.RemoteQuotaInfo;
import com.tencent.polaris.api.utils.ClosableReadWriteLock;
import com.tencent.polaris.plugins.ratelimiter.common.bucket.BucketShareInfo;
import com.tencent.polaris.plugins.ratelimiter.common.bucket.UpdateIdentifier;
import com.tencent.polaris.plugins.ratelimiter.common.slide.SlidingWindow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucket
implements Comparable<TokenBucket> {
    private static final Logger LOG = LoggerFactory.getLogger(TokenBucket.class);
    private final UpdateIdentifier tokenBucketTimeSet = new UpdateIdentifier();
    private final BucketShareInfo shareInfo;
    private final String windowKey;
    private final long validDurationMs;
    private final int validDurationSecond;
    private final AtomicLong ruleToken = new AtomicLong(0L);
    private final AtomicLong tokenLeft = new AtomicLong(0L);
    private final AtomicLong remoteToLocalTokenLeft = new AtomicLong(0L);
    private final AtomicInteger instanceCount = new AtomicInteger(0);
    private final ClosableReadWriteLock lock = new ClosableReadWriteLock();
    private final SlidingWindow slidingWindow;

    @Override
    public int compareTo(TokenBucket o) {
        return (int)(this.validDurationMs - o.validDurationMs);
    }

    public TokenBucket(String windowKey, long validDurationMs, int tokenAmount, BucketShareInfo shareInfo) {
        this.windowKey = windowKey;
        this.validDurationMs = validDurationMs;
        this.validDurationSecond = (int)((double)validDurationMs / 1000.0);
        this.ruleToken.set(tokenAmount);
        this.tokenLeft.set(tokenAmount);
        this.slidingWindow = new SlidingWindow(1, validDurationMs);
        this.shareInfo = shareInfo;
        this.instanceCount.set(1);
    }

    public long getRuleTotal() {
        if (!this.shareInfo.isShareEqual() || this.shareInfo.isLocal()) {
            return this.ruleToken.get();
        }
        return this.ruleToken.get() * (long)this.instanceCount.get();
    }

    public SlidingWindow getSlidingWindow() {
        return this.slidingWindow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void giveBackToken(UpdateIdentifier identifier, long token, TokenBucketMode mode) {
        try (ClosableReadWriteLock.LockWrapper readLock = this.lock.readLock();){
            readLock.lock();
            switch (mode) {
                case REMOTE: {
                    if (this.tokenBucketTimeSet.getLastRemoteUpdateMs().get() != identifier.getLastRemoteUpdateMs().get()) return;
                    this.tokenLeft.addAndGet(token);
                    return;
                }
                case LOCAL: {
                    if (this.tokenBucketTimeSet.getStageStartMs().get() != identifier.getStageStartMs().get()) return;
                    this.tokenLeft.addAndGet(token);
                    return;
                }
                case REMOTE_TO_LOCAL: {
                    if (this.tokenBucketTimeSet.getStageStartMs().get() != identifier.getStageStartMs().get()) return;
                    this.remoteToLocalTokenLeft.addAndGet(token);
                    return;
                }
            }
            return;
        }
    }

    private void updateRemoteClientCount(RemoteQuotaInfo remoteQuotaInfo) {
        long lastRemoteClientUpdateMs = this.tokenBucketTimeSet.getLastRemoteClientUpdateMs().get();
        if (lastRemoteClientUpdateMs < remoteQuotaInfo.getCurTimeMs()) {
            int curClientCount = remoteQuotaInfo.getClientCount() == 0 ? 1 : remoteQuotaInfo.getClientCount();
            int lastClientCount = this.instanceCount.getAndSet(curClientCount);
            if (lastClientCount != curClientCount) {
                LOG.info("[RateLimit]clientCount change from {} to {}, windowKey {}", new Object[]{lastClientCount, curClientCount, this.windowKey});
            }
            this.tokenBucketTimeSet.getLastRemoteClientUpdateMs().set(remoteQuotaInfo.getCurTimeMs());
        }
    }

    public void syncUpdateRemoteClientCount(RemoteQuotaInfo remoteQuotaInfo) {
        try (ClosableReadWriteLock.LockWrapper writeLock = this.lock.writeLock();){
            writeLock.lock();
            this.updateRemoteClientCount(remoteQuotaInfo);
        }
    }

    public void syncUpdateRemoteToken(RemoteQuotaInfo remoteQuotaInfo) {
        try (ClosableReadWriteLock.LockWrapper writeLock = this.lock.writeLock();){
            writeLock.lock();
            this.updateRemoteClientCount(remoteQuotaInfo);
            long used = this.slidingWindow.touchCurrentPassed(remoteQuotaInfo.getCurTimeMs());
            this.tokenLeft.set(remoteQuotaInfo.getRemoteQuotaLeft() - used);
            this.tokenBucketTimeSet.getLastRemoteUpdateMs().set(remoteQuotaInfo.getCurTimeMs());
        }
    }

    private boolean isRemoteNotExpired(long nowMs) {
        return nowMs - this.tokenBucketTimeSet.getLastRemoteUpdateMs().get() <= this.shareInfo.getMinDurationMs();
    }

    private long calculateStageStart(long curTimeMs) {
        return curTimeMs - curTimeMs % this.validDurationMs;
    }

    private void initLocalStageOnLocalConfig(long nowMs) {
        long nowStageMs = this.calculateStageStart(nowMs);
        if (this.tokenBucketTimeSet.getStageStartMs().get() == nowStageMs) {
            return;
        }
        try (ClosableReadWriteLock.LockWrapper writeLock = this.lock.writeLock();){
            writeLock.lock();
            if (this.isRemoteNotExpired(nowMs)) {
                return;
            }
            if (this.tokenBucketTimeSet.getStageStartMs().get() == nowStageMs) {
                return;
            }
            this.tokenLeft.set(this.ruleToken.get());
            this.tokenBucketTimeSet.getStageStartMs().set(nowStageMs);
        }
    }

    private AllocateResult tryAllocateLocal(int token, long nowMs, UpdateIdentifier identifier, AllocateResult result) {
        this.initLocalStageOnLocalConfig(nowMs);
        try (ClosableReadWriteLock.LockWrapper readLock = this.lock.readLock();){
            readLock.lock();
            identifier.getStageStartMs().set(this.tokenBucketTimeSet.getStageStartMs().get());
            identifier.getLastRemoteUpdateMs().set(this.tokenBucketTimeSet.getLastRemoteUpdateMs().get());
            result.setSuccess(true);
            result.setMode(TokenBucketMode.LOCAL);
            result.setLeft(this.tokenLeft.addAndGet(-token));
            AllocateResult allocateResult = result;
            return allocateResult;
        }
    }

    private long directAllocateRemoteToken(int token) {
        return this.tokenLeft.addAndGet(-token);
    }

    private AllocateResult allocateRemoteReadOnly(int token, long nowMs, UpdateIdentifier identifier, AllocateResult result) {
        try (ClosableReadWriteLock.LockWrapper readLock = this.lock.readLock();){
            readLock.lock();
            if (this.isRemoteNotExpired(nowMs)) {
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE);
                result.setLeft(this.directAllocateRemoteToken(token));
                AllocateResult allocateResult = result;
                return allocateResult;
            }
            if (this.shareInfo.isPassOnRemoteFail()) {
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE_TO_LOCAL);
                result.setLeft(0L);
                AllocateResult allocateResult = result;
                return allocateResult;
            }
            long stageStartMs = this.tokenBucketTimeSet.getStageStartMs().get();
            if (stageStartMs == this.calculateStageStart(nowMs)) {
                identifier.getStageStartMs().set(stageStartMs);
                identifier.getLastRemoteUpdateMs().set(this.tokenBucketTimeSet.getLastRemoteUpdateMs().get());
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE_TO_LOCAL);
                result.setLeft(this.remoteToLocalTokenLeft.addAndGet(-token));
                AllocateResult allocateResult = result;
                return allocateResult;
            }
            result.setSuccess(false);
            result.setMode(TokenBucketMode.REMOTE_TO_LOCAL);
            result.setLeft(0L);
            AllocateResult allocateResult = result;
            return allocateResult;
        }
    }

    private long createRemoteToLocalTokens(long nowMs, int token, UpdateIdentifier identifier, long stageStartMs) {
        long nowStageMs = this.calculateStageStart(nowMs);
        if (stageStartMs == nowStageMs) {
            identifier.getStageStartMs().set(stageStartMs);
            return this.remoteToLocalTokenLeft.addAndGet(-token);
        }
        long tokenPerInst = (long)Math.ceil((double)this.getRuleTotal() / (double)this.instanceCount.get());
        if (tokenPerInst == 0L) {
            tokenPerInst = 1L;
        }
        this.remoteToLocalTokenLeft.set(tokenPerInst);
        this.tokenBucketTimeSet.getStageStartMs().set(nowStageMs);
        identifier.getStageStartMs().set(nowMs);
        return this.remoteToLocalTokenLeft.addAndGet(-token);
    }

    private long allocateRemoteToLocal(int token, long nowMs, UpdateIdentifier identifier) {
        if (this.shareInfo.isPassOnRemoteFail()) {
            return 0L;
        }
        long stageStartMs = this.tokenBucketTimeSet.getStageStartMs().get();
        try (ClosableReadWriteLock.LockWrapper readLock = this.lock.readLock();){
            readLock.lock();
            if (stageStartMs == this.calculateStageStart(nowMs)) {
                identifier.getStageStartMs().set(stageStartMs);
                identifier.getLastRemoteUpdateMs().set(this.tokenBucketTimeSet.getLastRemoteUpdateMs().get());
                long l = this.remoteToLocalTokenLeft.addAndGet(-token);
                return l;
            }
        }
        var8_6 = null;
        try (ClosableReadWriteLock.LockWrapper writeLock = this.lock.writeLock();){
            writeLock.lock();
            long l = this.createRemoteToLocalTokens(nowMs, token, identifier, stageStartMs);
            return l;
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
    }

    private AllocateResult tryAllocateRemote(int token, long nowMs, UpdateIdentifier identifier, AllocateResult result) {
        AllocateResult allocateResult = this.allocateRemoteReadOnly(token, nowMs, identifier, result);
        if (allocateResult.isSuccess()) {
            return allocateResult;
        }
        try (ClosableReadWriteLock.LockWrapper writeLock = this.lock.writeLock();){
            writeLock.lock();
            long stageStartMs = this.tokenBucketTimeSet.getStageStartMs().get();
            identifier.getLastRemoteUpdateMs().set(this.tokenBucketTimeSet.getLastRemoteUpdateMs().get());
            if (this.isRemoteNotExpired(nowMs)) {
                identifier.getStageStartMs().set(stageStartMs);
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE);
                result.setLeft(this.tokenLeft.addAndGet(-token));
                AllocateResult allocateResult2 = result;
                return allocateResult2;
            }
            result.setSuccess(true);
            result.setMode(TokenBucketMode.REMOTE_TO_LOCAL);
            result.setLeft(this.createRemoteToLocalTokens(nowMs, token, identifier, stageStartMs));
            AllocateResult allocateResult3 = result;
            return allocateResult3;
        }
    }

    public AllocateResult tryAllocateToken(TokenBucketMode mode, int token, long nowMs, UpdateIdentifier identifier, AllocateResult result) {
        switch (mode) {
            case LOCAL: {
                return this.tryAllocateLocal(token, nowMs, identifier, result);
            }
            case REMOTE: {
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE);
                result.setLeft(this.directAllocateRemoteToken(token));
                return result;
            }
            case REMOTE_TO_LOCAL: {
                result.setSuccess(true);
                result.setMode(TokenBucketMode.REMOTE_TO_LOCAL);
                result.setLeft(this.allocateRemoteToLocal(token, nowMs, identifier));
                return result;
            }
        }
        if (this.shareInfo.isLocal()) {
            return this.tryAllocateLocal(token, nowMs, identifier, result);
        }
        return this.tryAllocateRemote(token, nowMs, identifier, result);
    }

    public String getWindowKey() {
        return this.windowKey;
    }

    public void confirmPassed(long passed, long nowMs) {
        this.slidingWindow.addAndGetCurrentPassed(nowMs, passed);
    }

    public void confirmLimited(long limited, long nowMs) {
        this.slidingWindow.addAndGetCurrentLimited(nowMs, limited);
    }

    public int getValidDurationSecond() {
        return this.validDurationSecond;
    }

    public static class AllocateResult {
        private boolean success;
        private TokenBucketMode mode;
        private long left;

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setMode(TokenBucketMode mode) {
            this.mode = mode;
        }

        public void setLeft(long left) {
            this.left = left;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public TokenBucketMode getMode() {
            return this.mode;
        }

        public long getLeft() {
            return this.left;
        }
    }

    public static enum TokenBucketMode {
        UNKNOWN,
        REMOTE,
        REMOTE_TO_LOCAL,
        LOCAL;

    }
}

