/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.unirate;

import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class LeakyBucket
implements Comparable<LeakyBucket> {
    private static final Logger LOG = LoggerFactory.getLogger(LeakyBucket.class);
    private RateLimitProto.Rule rule;
    private AtomicLong lastGrantTime = new AtomicLong(0L);
    private Integer effectiveAmount;
    private Long effectiveDuration;
    private Long effectiveRate;
    private Double totalRate;
    private Long maxQueuingDuration;
    private Boolean rejectAll = false;

    public QuotaResult getQuota() {
        long waitDuration;
        long costDuration;
        block4: {
            long currentTimestamp;
            long expectedTimestamp;
            if (this.getRejectAll().booleanValue()) {
                return new QuotaResult(QuotaResult.Code.QuotaResultLimited, 0L, "uniRate RateLimiter: reject for zero rule amount");
            }
            costDuration = this.effectiveRate;
            waitDuration = 0L;
            do {
                currentTimestamp = System.currentTimeMillis();
                expectedTimestamp = this.lastGrantTime.addAndGet(costDuration);
                waitDuration = expectedTimestamp - currentTimestamp;
                if (waitDuration >= 0L) break block4;
            } while (!this.lastGrantTime.compareAndSet(expectedTimestamp, currentTimestamp));
            waitDuration = 0L;
        }
        if (waitDuration == 0L) {
            LOG.debug("grant quota without wait.");
            return new QuotaResult(QuotaResult.Code.QuotaResultOk, 0L, "uniRate RateLimiter: grant quota");
        }
        if (waitDuration <= this.maxQueuingDuration) {
            LOG.debug("grant quota, waitDuration {}ms.", (Object)waitDuration);
            return new QuotaResult(QuotaResult.Code.QuotaResultOk, waitDuration, "uniRate RateLimiter: grant quota");
        }
        LOG.debug("ratelimited, waitDuration {}ms.", (Object)waitDuration);
        String info = String.format("uniRate RateLimiter: queueing time %d exceed maxQueuingTime %s", waitDuration, this.maxQueuingDuration);
        this.lastGrantTime.addAndGet(-costDuration);
        return new QuotaResult(QuotaResult.Code.QuotaResultLimited, 0L, info);
    }

    @Override
    public int compareTo(LeakyBucket o) {
        return (int)(this.effectiveRate - o.effectiveDuration);
    }

    public RateLimitProto.Rule getRule() {
        return this.rule;
    }

    public void setRule(RateLimitProto.Rule rule) {
        this.rule = rule;
    }

    public Long getLastGrantTime() {
        return this.lastGrantTime.get();
    }

    public Integer getEffectiveAmount() {
        return this.effectiveAmount;
    }

    public void setEffectiveAmount(Integer effectiveAmount) {
        this.effectiveAmount = effectiveAmount;
    }

    public Long getEffectiveDuration() {
        return this.effectiveDuration;
    }

    public void setEffectiveDuration(Long effectiveDuration) {
        this.effectiveDuration = effectiveDuration;
    }

    public Long getEffectiveRate() {
        return this.effectiveRate;
    }

    public void setEffectiveRate(Long effectiveRate) {
        this.effectiveRate = effectiveRate;
    }

    public Double getTotalRate() {
        return this.totalRate;
    }

    public void setTotalRate(Double totalRate) {
        this.totalRate = totalRate;
    }

    public Long getMaxQueuingDuration() {
        return this.maxQueuingDuration;
    }

    public void setMaxQueuingDuration(Long maxQueuingDuration) {
        this.maxQueuingDuration = maxQueuingDuration;
    }

    public Boolean getRejectAll() {
        return this.rejectAll;
    }

    public void setRejectAll(Boolean rejectAll) {
        this.rejectAll = rejectAll;
    }
}

