/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.registry.memory;

import com.google.protobuf.Message;
import com.tencent.polaris.api.config.global.APIConfig;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.ServerServiceInfo;
import com.tencent.polaris.api.plugin.registry.CacheHandler;
import com.tencent.polaris.api.plugin.registry.EventCompleteNotifier;
import com.tencent.polaris.api.plugin.registry.InstanceProperty;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.plugin.registry.ServiceUpdateRequest;
import com.tencent.polaris.api.plugin.server.EventHandler;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.plugin.stat.CircuitBreakGauge;
import com.tencent.polaris.api.plugin.stat.DefaultCircuitBreakResult;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.registry.memory.CacheObject;
import com.tencent.polaris.plugins.registry.memory.MessagePersistHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class InMemoryRegistry
extends Destroyable
implements LocalRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryRegistry.class);
    private static final long defaultDiscoverServiceRetryIntervalMs = 5000L;
    private final Map<ServiceEventKey, CacheObject> resourceMap = new ConcurrentHashMap<ServiceEventKey, CacheObject>();
    private final List<ResourceEventListener> resourceEventListeners = new CopyOnWriteArrayList<ResourceEventListener>();
    private final Map<ServiceKey, Boolean> services = new ConcurrentHashMap<ServiceKey, Boolean>();
    private final Map<ServiceEventKey.EventType, CacheHandler> cacheHandlers = new HashMap<ServiceEventKey.EventType, CacheHandler>();
    private final Map<ServiceKey, ServerServiceInfo> serverServiceMap = new HashMap<ServiceKey, ServerServiceInfo>();
    private ServerConnector connector;
    private MessagePersistHandler messagePersistHandler;
    private ExecutorService persistExecutor;
    private ScheduledExecutorService expireExecutor;
    private ExecutorService serverServicesDiscoverExecutor;
    private long serviceRefreshIntervalMs;
    private long serviceListRefreshIntervalMs;
    private boolean persistEnable;
    private long serviceExpireTimeMs;
    private boolean hasDiscoverCluster = false;
    private Collection<Plugin> statPlugins;

    public Set<ServiceKey> getServices() {
        return this.services.keySet();
    }

    public ServiceRule getServiceRule(ResourceFilter filter) {
        RegistryCacheValue resourceCache = this.getResource(filter.getSvcEventKey(), filter.isIncludeCache(), filter.isInternalRequest());
        if (null == resourceCache) {
            return CacheObject.EMPTY_SERVICE_RULE;
        }
        return (ServiceRule)resourceCache;
    }

    private RegistryCacheValue getResource(ServiceEventKey svcEventKey, boolean includeCache, boolean internalRequest) {
        CacheObject cacheObject = this.resourceMap.get(svcEventKey);
        if (null == cacheObject) {
            return null;
        }
        RegistryCacheValue registryCacheValue = cacheObject.loadValue(!internalRequest);
        if (null == registryCacheValue) {
            return null;
        }
        if (cacheObject.isRemoteUpdated() || includeCache) {
            return registryCacheValue;
        }
        return null;
    }

    public ServiceInstances getInstances(ResourceFilter filter) {
        RegistryCacheValue resourceCache = this.getResource(filter.getSvcEventKey(), filter.isIncludeCache(), filter.isInternalRequest());
        if (null == resourceCache) {
            return CacheObject.EMPTY_INSTANCES;
        }
        return (ServiceInstances)resourceCache;
    }

    public void loadServiceRule(ServiceEventKey svcEventKey, EventCompleteNotifier notifier) throws PolarisException {
        this.loadRemoteValue(svcEventKey, notifier);
    }

    public Services getServices(ResourceFilter filter) {
        RegistryCacheValue resourceCache = this.getResource(filter.getSvcEventKey(), filter.isIncludeCache(), filter.isInternalRequest());
        if (null == resourceCache) {
            return CacheObject.EMPTY_SERVICE;
        }
        return (Services)resourceCache;
    }

    public void loadServices(ServiceEventKey svcEventKey, EventCompleteNotifier notifier) throws PolarisException {
        this.loadRemoteValue(svcEventKey, notifier);
    }

    private ServerConnector getConnector() {
        return this.connector;
    }

    private void loadRemoteValue(ServiceEventKey svcEventKey, EventCompleteNotifier notifier) throws PolarisException {
        this.checkDestroyed();
        CacheHandler handler = this.cacheHandlers.get(svcEventKey.getEventType());
        if (null == handler) {
            throw new PolarisException(ErrorCode.INTERNAL_ERROR, String.format("[LocalRegistry] unRegistered resource type %s", svcEventKey.getEventType()));
        }
        CacheObject cacheObject = this.resourceMap.computeIfAbsent(svcEventKey, serviceEventKey -> new CacheObject(handler, svcEventKey, this));
        cacheObject.addNotifier(notifier);
        if (cacheObject.startRegister()) {
            LOG.info("[LocalRegistry]start to register service handler for {}", (Object)svcEventKey);
            try {
                this.connector.registerServiceHandler(this.enhanceServiceEventHandler(new ServiceEventHandler(svcEventKey, (EventHandler)cacheObject)));
            }
            catch (Throwable e) {
                PolarisException polarisException = e instanceof PolarisException ? (PolarisException)e : new PolarisException(ErrorCode.INTERNAL_ERROR, String.format("exception occurs while registering service handler for %s", svcEventKey));
                cacheObject.resumeUnRegistered(polarisException);
                throw polarisException;
            }
            if (svcEventKey.getEventType() == ServiceEventKey.EventType.INSTANCE) {
                this.services.put(svcEventKey.getServiceKey(), true);
            }
        }
    }

    private ServiceEventHandler enhanceServiceEventHandler(ServiceEventHandler eventHandler) {
        ServiceKey serviceKey = eventHandler.getServiceEventKey().getServiceKey();
        ServerServiceInfo info = this.serverServiceMap.get(serviceKey);
        if (null != info) {
            eventHandler.setRefreshInterval(info.getRefreshIntervalMs());
            if (info.getClusterType() != ClusterType.SERVICE_DISCOVER_CLUSTER) {
                eventHandler.setTargetCluster(ClusterType.SERVICE_DISCOVER_CLUSTER);
            } else {
                eventHandler.setTargetCluster(ClusterType.BUILTIN_CLUSTER);
            }
        } else {
            if (eventHandler.getServiceEventKey().getEventType() == ServiceEventKey.EventType.SERVICE) {
                eventHandler.setRefreshInterval(this.serviceListRefreshIntervalMs);
            } else {
                eventHandler.setRefreshInterval(this.serviceRefreshIntervalMs);
            }
            eventHandler.setTargetCluster(ClusterType.SERVICE_DISCOVER_CLUSTER);
        }
        return eventHandler;
    }

    public void loadInstances(ServiceEventKey svcEventKey, EventCompleteNotifier notifier) throws PolarisException {
        this.loadRemoteValue(svcEventKey, notifier);
    }

    private void onCircuitBreakStatus(Object value, InstanceLocalValue instanceLocalValue, Instance instance) {
        Map statusMap = (Map)value;
        if (MapUtils.isNotEmpty((Map)statusMap)) {
            for (Map.Entry<StatusDimension, CircuitBreakerStatus> entry : statusMap.entrySet()) {
                instanceLocalValue.setCircuitBreakerStatus((StatusDimension)entry.getKey(), (CircuitBreakerStatus)entry.getValue());
                this.reportCircuitStat(entry, instance);
            }
        }
    }

    private void reportCircuitStat(Map.Entry<StatusDimension, CircuitBreakerStatus> dimensionEntry, Instance instance) {
        if (null != this.statPlugins) {
            try {
                for (Plugin statPlugin : this.statPlugins) {
                    if (!(statPlugin instanceof StatReporter)) continue;
                    StatInfo info = new StatInfo();
                    info.setCircuitBreakGauge(this.convertToCircuitBreakGauge(dimensionEntry, instance));
                    ((StatReporter)statPlugin).reportStat(info);
                }
            }
            catch (Exception ex) {
                LOG.info("circuit breaker report encountered exception, e: {}", (Object)ex.getMessage());
            }
        }
    }

    private CircuitBreakGauge convertToCircuitBreakGauge(Map.Entry<StatusDimension, CircuitBreakerStatus> dimensionEntry, Instance instance) {
        DefaultCircuitBreakResult result = new DefaultCircuitBreakResult();
        result.setMethod(dimensionEntry.getKey().getMethod());
        result.setCallerService(dimensionEntry.getKey().getCallerService());
        result.setCircuitBreakStatus(dimensionEntry.getValue());
        result.setHost(instance.getHost());
        result.setPort(instance.getPort());
        result.setInstanceId(instance.getId());
        result.setService(instance.getService());
        result.setNamespace(instance.getNamespace());
        return result;
    }

    public void updateInstances(ServiceUpdateRequest request) {
        Collection instanceProperties = request.getProperties();
        if (CollectionUtils.isEmpty((Collection)instanceProperties)) {
            return;
        }
        RegistryCacheValue cacheValue = this.getResource(new ServiceEventKey(request.getServiceKey(), ServiceEventKey.EventType.INSTANCE), true, true);
        if (null == cacheValue) {
            return;
        }
        for (InstanceProperty instanceProperty : instanceProperties) {
            InstanceByProto instance = (InstanceByProto)instanceProperty.getInstance();
            InstanceLocalValue instanceLocalValue = instance.getInstanceLocalValue();
            Map properties = instanceProperty.getProperties();
            LOG.info("update instance properties for instance {}, properties {}", (Object)instance.getId(), (Object)properties);
            for (Map.Entry entry : properties.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "circuitBreakerStatus": {
                        this.onCircuitBreakStatus(entry.getValue(), instanceLocalValue, (Instance)instance);
                        break;
                    }
                    case "detectResult": {
                        instanceLocalValue.setDetectResult((DetectResult)entry.getValue());
                        break;
                    }
                }
            }
        }
    }

    public void registerResourceListener(ResourceEventListener listener) {
        this.resourceEventListeners.add(listener);
    }

    public Collection<ResourceEventListener> getResourceEventListeners() {
        return this.resourceEventListeners;
    }

    public String getName() {
        return "inmemory";
    }

    public PluginType getType() {
        return PluginTypes.LOCAL_REGISTRY.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        Collection serverServices = ctx.getServerServices();
        for (Object serverServiceInfo : serverServices) {
            if (serverServiceInfo.getClusterType() == ClusterType.SERVICE_DISCOVER_CLUSTER) {
                this.hasDiscoverCluster = true;
            }
            this.serverServiceMap.put(serverServiceInfo.getServiceKey(), (ServerServiceInfo)serverServiceInfo);
        }
        ServiceLoader<CacheHandler> handlers = ServiceLoader.load(CacheHandler.class);
        for (CacheHandler handler : handlers) {
            this.cacheHandlers.put(handler.getTargetEventType(), handler);
        }
        this.connector = (ServerConnector)ctx.getPlugins().getPlugin(PluginTypes.SERVER_CONNECTOR.getBaseType(), ctx.getValueContext().getServerConnectorProtocol());
        String persistDir = ctx.getConfig().getConsumer().getLocalCache().getPersistDir();
        int maxReadRetry = ctx.getConfig().getConsumer().getLocalCache().getPersistMaxReadRetry();
        int maxWriteRetry = ctx.getConfig().getConsumer().getLocalCache().getPersistMaxWriteRetry();
        long retryIntervalMs = ctx.getConfig().getConsumer().getLocalCache().getPersistRetryInterval();
        this.serviceRefreshIntervalMs = ctx.getConfig().getConsumer().getLocalCache().getServiceRefreshInterval();
        this.serviceListRefreshIntervalMs = ctx.getConfig().getConsumer().getLocalCache().getServiceListRefreshInterval();
        boolean configPersistEnable = ctx.getConfig().getConsumer().getLocalCache().isPersistEnable();
        boolean bl = this.persistEnable = configPersistEnable && StringUtils.isNotBlank((String)persistDir);
        if (this.persistEnable) {
            this.messagePersistHandler = new MessagePersistHandler(persistDir, maxWriteRetry, maxReadRetry, retryIntervalMs);
            try {
                this.messagePersistHandler.init();
            }
            catch (IOException e) {
                throw new PolarisException(ErrorCode.PLUGIN_ERROR, String.format("plugin %s init failed", this.getName()), (Throwable)e);
            }
            this.loadFileCache(persistDir);
        }
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory(this.getName());
        this.serviceExpireTimeMs = ctx.getConfig().getConsumer().getLocalCache().getServiceExpireTime();
        this.persistExecutor = Executors.newSingleThreadExecutor((ThreadFactory)namedThreadFactory);
        this.expireExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)namedThreadFactory);
        if (this.hasDiscoverCluster) {
            this.serverServicesDiscoverExecutor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)namedThreadFactory);
        }
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.expireExecutor.scheduleAtFixedRate(new ExpireTask(), 0L, this.serviceExpireTimeMs, TimeUnit.MILLISECONDS);
        if (null != this.serverServicesDiscoverExecutor) {
            this.serverServicesDiscoverExecutor.execute(new WarmupDiscoverServiceTask(extensions));
        }
        this.statPlugins = extensions.getPlugins().getPlugins(PluginTypes.STAT_REPORTER.getBaseType());
    }

    public void saveMessageToFile(ServiceEventKey svcEventKey, Message message) {
        if (!this.persistEnable) {
            return;
        }
        if (!this.persistExecutor.isShutdown()) {
            this.persistExecutor.execute(new SavePersistTask(svcEventKey, message));
        }
    }

    private void deleteFileMessage(ServiceEventKey svcEventKey) {
        if (!this.persistEnable) {
            return;
        }
        if (!this.persistExecutor.isShutdown()) {
            this.persistExecutor.execute(new DeletePersistTask(svcEventKey));
        }
    }

    private void loadFileCache(String persistPath) {
        LOG.info("start to load local cache files from {}", (Object)persistPath);
        Map<ServiceEventKey, Message> loadCachedServices = this.messagePersistHandler.loadPersistedServices((Message)ResponseProto.DiscoverResponse.getDefaultInstance());
        for (Map.Entry<ServiceEventKey, Message> entry : loadCachedServices.entrySet()) {
            ServiceEventKey svcEventKey = entry.getKey();
            Message message = entry.getValue();
            if (null == message) {
                LOG.warn("load local cache, response is null, service event:{}", (Object)svcEventKey);
                continue;
            }
            CacheHandler cacheHandler = this.cacheHandlers.get(svcEventKey.getEventType());
            if (null == cacheHandler) {
                LOG.warn("[LocalRegistry]resource type {} not registered, ignore the file", (Object)svcEventKey.getEventType());
                continue;
            }
            CacheObject cacheObject = new CacheObject(cacheHandler, svcEventKey, this, message);
            this.resourceMap.put(svcEventKey, cacheObject);
        }
        LOG.info("loaded {} services from local cache", (Object)loadCachedServices.size());
    }

    public void removeCache(ServiceEventKey serviceEventKey) {
        LOG.info("[LocalRegistry] remove cache for resource {}", (Object)serviceEventKey);
        try {
            this.getConnector().deRegisterServiceHandler(serviceEventKey);
        }
        catch (PolarisException e) {
            LOG.error("[LocalRegistry] fail to deRegisterServiceHandler", (Throwable)e);
        }
        this.resourceMap.remove(serviceEventKey);
        if (serviceEventKey.getEventType() == ServiceEventKey.EventType.INSTANCE) {
            this.services.remove(serviceEventKey.getServiceKey());
        }
        this.deleteFileMessage(serviceEventKey);
    }

    protected void doDestroy() {
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.serverServicesDiscoverExecutor, this.persistExecutor, this.expireExecutor});
    }

    public void setServerServiceReady(ServiceEventKey serviceEventKey) {
        if (!this.serverServiceMap.containsKey(serviceEventKey.getServiceKey())) {
            return;
        }
        this.connector.updateServers(serviceEventKey);
    }

    private class WarmupDiscoverServiceTask
    implements Runnable {
        private final Extensions extensions;

        public WarmupDiscoverServiceTask(Extensions extensions) {
            this.extensions = extensions;
        }

        private void retryTask() {
            Utils.sleepUninterrupted((long)5000L);
            ExecutorService serverServicesDiscoverExecutor = InMemoryRegistry.this.serverServicesDiscoverExecutor;
            if (null != serverServicesDiscoverExecutor && !serverServicesDiscoverExecutor.isShutdown()) {
                serverServicesDiscoverExecutor.execute(new WarmupDiscoverServiceTask(this.extensions));
            }
        }

        @Override
        public void run() {
            ResourcesResponse resourcesResponse;
            ServiceKey discoverSvcKey = null;
            Map serverServiceMap = InMemoryRegistry.this.serverServiceMap;
            for (Map.Entry entry : serverServiceMap.entrySet()) {
                if (((ServerServiceInfo)entry.getValue()).getClusterType() != ClusterType.SERVICE_DISCOVER_CLUSTER) continue;
                discoverSvcKey = (ServiceKey)entry.getKey();
                break;
            }
            if (null == discoverSvcKey) {
                LOG.warn("[LocalRegistry] discover service not config");
                return;
            }
            ServiceEventKey svcEventKey = new ServiceEventKey(discoverSvcKey, ServiceEventKey.EventType.INSTANCE);
            DefaultServiceEventKeysProvider provider = new DefaultServiceEventKeysProvider();
            provider.setSvcEventKey(svcEventKey);
            DefaultFlowControlParam defaultFlowControlParam = new DefaultFlowControlParam();
            APIConfig apiConfig = this.extensions.getConfiguration().getGlobal().getAPI();
            defaultFlowControlParam.setTimeoutMs(apiConfig.getTimeout());
            defaultFlowControlParam.setMaxRetry(apiConfig.getMaxRetryTimes());
            defaultFlowControlParam.setRetryIntervalMs(apiConfig.getRetryInterval());
            try {
                resourcesResponse = BaseFlow.syncGetResources((Extensions)this.extensions, (boolean)false, (ServiceEventKeysProvider)provider, (FlowControlParam)defaultFlowControlParam);
            }
            catch (PolarisException e) {
                if (e.getCode() == ErrorCode.INVALID_STATE) {
                    return;
                }
                LOG.error("[LocalRegistry] fail to fetch server service {}", (Object)svcEventKey, (Object)e);
                this.retryTask();
                return;
            }
            ServiceInstances serviceInstances = resourcesResponse.getServiceInstances(svcEventKey);
            RegistryCacheValue cacheValue = (RegistryCacheValue)serviceInstances;
            if (!cacheValue.isInitialized()) {
                this.retryTask();
            }
        }
    }

    private class ExpireTask
    implements Runnable {
        private ExpireTask() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : InMemoryRegistry.this.resourceMap.entrySet()) {
                CacheObject cacheObject = (CacheObject)entry.getValue();
                long lastAccessTime = cacheObject.getLastAccessTimeMs();
                if (lastAccessTime == 0L) continue;
                long nowMs = System.currentTimeMillis();
                long diffTimeMs = nowMs - lastAccessTime;
                if (diffTimeMs < 0L) {
                    cacheObject.setLastAccessTimeMs(nowMs);
                    continue;
                }
                if (diffTimeMs < InMemoryRegistry.this.serviceExpireTimeMs) continue;
                InMemoryRegistry.this.removeCache((ServiceEventKey)entry.getKey());
            }
        }
    }

    private class DeletePersistTask
    implements Runnable {
        final ServiceEventKey svcEventKey;

        DeletePersistTask(ServiceEventKey svcEventKey) {
            this.svcEventKey = svcEventKey;
        }

        @Override
        public void run() {
            InMemoryRegistry.this.messagePersistHandler.deleteService(this.svcEventKey);
        }
    }

    private class SavePersistTask
    implements Runnable {
        final ServiceEventKey svcEventKey;
        final Message message;

        SavePersistTask(ServiceEventKey svcEventKey, Message message) {
            this.svcEventKey = svcEventKey;
            this.message = message;
        }

        @Override
        public void run() {
            InMemoryRegistry.this.messagePersistHandler.saveService(this.svcEventKey, this.message);
        }
    }
}

