/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.local.cache.memory;

import com.google.protobuf.Message;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.registry.CacheHandler;
import com.tencent.polaris.api.plugin.registry.EventCompleteNotifier;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.plugin.server.EventHandler;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.plugins.local.cache.memory.InMemoryRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheObject
implements EventHandler {
    public static final ServiceInstancesByProto EMPTY_SERVICES = new ServiceInstancesByProto();
    public static final ServiceRuleByProto EMPTY_SERVICE_RULE = new ServiceRuleByProto();
    private static final Logger LOG = LoggerFactory.getLogger(CacheObject.class);
    private final AtomicReference<RegistryCacheValue> value = new AtomicReference();
    private final ServiceEventKey svcEventKey;
    private final CacheHandler cacheHandler;
    private final InMemoryRegistry registry;
    private final Object lock = new Object();
    private final List<EventCompleteNotifier> notifiers = new ArrayList<EventCompleteNotifier>();
    private final AtomicLong lastAccessTimeMs = new AtomicLong(0L);
    private final long createTime;
    private final AtomicBoolean remoteUpdated = new AtomicBoolean(false);
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final AtomicBoolean notifyResourceAdded = new AtomicBoolean(false);

    public CacheObject(CacheHandler cacheHandler, ServiceEventKey svcEventKey, InMemoryRegistry registry) {
        long nowMs;
        this.svcEventKey = svcEventKey;
        this.registry = registry;
        this.cacheHandler = cacheHandler;
        this.createTime = nowMs = System.currentTimeMillis();
        this.setLastAccessTimeMs(nowMs);
    }

    public CacheObject(CacheHandler cacheHandler, ServiceEventKey svcEventKey, InMemoryRegistry registry, Message initValue) {
        long nowMs;
        this.svcEventKey = svcEventKey;
        this.registry = registry;
        this.cacheHandler = cacheHandler;
        this.createTime = nowMs = System.currentTimeMillis();
        this.setLastAccessTimeMs(nowMs);
        RegistryCacheValue registryCacheValue = cacheHandler.messageToCacheValue(null, (Object)initValue, true);
        this.value.set(registryCacheValue);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public boolean isRemoteUpdated() {
        return this.remoteUpdated.get();
    }

    private void notifyEvent(Throwable error) {
        if (CollectionUtils.isEmpty(this.notifiers)) {
            return;
        }
        this.notifiers.forEach(notifier -> {
            if (null != error) {
                notifier.completeExceptionally(this.svcEventKey, error);
            } else {
                notifier.complete(this.svcEventKey);
            }
        });
        this.notifiers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifier(EventCompleteNotifier notifier) {
        if (this.checkNotifyNow(notifier)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.checkNotifyNow(notifier)) {
                return;
            }
            this.notifiers.add(notifier);
        }
    }

    public RegistryCacheValue loadValue(boolean updateVisitTime) {
        Collection<ResourceEventListener> resourceEventListeners;
        RegistryCacheValue registryCacheValue;
        if (updateVisitTime) {
            this.lastAccessTimeMs.set(System.currentTimeMillis());
        }
        if (null == (registryCacheValue = this.value.get())) {
            return null;
        }
        if (this.notifyResourceAdded.compareAndSet(false, true) && !CollectionUtils.isEmpty(resourceEventListeners = this.registry.getResourceEventListeners())) {
            for (ResourceEventListener listener : resourceEventListeners) {
                listener.onResourceAdd(this.svcEventKey, registryCacheValue);
            }
        }
        return registryCacheValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEventUpdate(ServerEvent event) {
        ServiceEventKey serviceEventKey = event.getServiceEventKey();
        PolarisException error = event.getError();
        this.remoteUpdated.set(true);
        boolean svcDeleted = false;
        Collection<ResourceEventListener> resourceEventListeners = this.registry.getResourceEventListeners();
        if (null != error) {
            RegistryCacheValue registryCacheValue = this.loadValue(false);
            if (error.getCode() == ErrorCode.SERVICE_NOT_FOUND) {
                if (this.deleted.compareAndSet(false, true)) {
                    this.registry.removeCache(serviceEventKey);
                    for (ResourceEventListener listener : resourceEventListeners) {
                        listener.onResourceDeleted(this.svcEventKey, registryCacheValue);
                    }
                    svcDeleted = true;
                }
            } else {
                LOG.error(String.format("received error notify for service %s", serviceEventKey), (Throwable)error);
            }
        } else {
            boolean newRemoteCache;
            Object message = event.getValue();
            RegistryCacheValue cachedValue = this.value.get();
            CacheHandler.CachedStatus cachedStatus = this.cacheHandler.compareMessage(cachedValue, message);
            if (cachedStatus == CacheHandler.CachedStatus.CacheChanged || cachedStatus == CacheHandler.CachedStatus.CacheNotExists) {
                LOG.info("OnServiceUpdate: cache {} is pending to update", (Object)this.svcEventKey);
                this.registry.saveMessageToFile(serviceEventKey, (Message)message);
                RegistryCacheValue newCachedValue = this.cacheHandler.messageToCacheValue(cachedValue, message, false);
                this.setValue(newCachedValue);
                if (cachedStatus == CacheHandler.CachedStatus.CacheChanged) {
                    for (ResourceEventListener listener : resourceEventListeners) {
                        listener.onResourceUpdated(this.svcEventKey, cachedValue, newCachedValue);
                    }
                }
            } else if (cachedStatus == CacheHandler.CachedStatus.CacheEmptyButNoData) {
                LOG.error("OnServiceUpdate: {} is empty, but discover returns no data", (Object)this.svcEventKey);
            }
            boolean bl = newRemoteCache = null == cachedValue || cachedValue.isLoadedFromFile();
            if (newRemoteCache && serviceEventKey.getEventType() == ServiceEventKey.EventType.INSTANCE) {
                this.registry.setServerServiceReady(serviceEventKey);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.notifyEvent((Throwable)error);
        }
        return svcDeleted;
    }

    private void setValue(RegistryCacheValue registryCacheValue) {
        this.value.set(registryCacheValue);
        LOG.info("CacheObject: value for {} is updated, revision {}", (Object)this.svcEventKey, (Object)registryCacheValue.getRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startRegister() {
        Object object = this.lock;
        synchronized (object) {
            return this.registered.compareAndSet(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeUnRegistered(PolarisException e) {
        Object object = this.lock;
        synchronized (object) {
            this.registered.compareAndSet(true, false);
            this.notifyEvent((Throwable)e);
        }
    }

    private boolean checkResourceAvailable() {
        RegistryCacheValue registryCacheValue = this.value.get();
        if (null == registryCacheValue) {
            return false;
        }
        return registryCacheValue.isInitialized() && !registryCacheValue.isLoadedFromFile();
    }

    private boolean checkNotifyNow(EventCompleteNotifier notifier) {
        if (this.checkResourceAvailable()) {
            notifier.complete(this.svcEventKey);
            return true;
        }
        return false;
    }

    public long getLastAccessTimeMs() {
        return this.lastAccessTimeMs.get();
    }

    public void setLastAccessTimeMs(long value) {
        this.lastAccessTimeMs.set(value);
    }

    public ServiceEventKey getServiceEventKey() {
        return this.svcEventKey;
    }
}

