/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.healthy;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RecoverRouter
extends AbstractServiceRouter {
    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        List healthyInstance = instances.getInstances().stream().filter(instance -> Utils.isHealthyInstance((Instance)instance, (Map)routeInfo.getStatusDimensions())).collect(Collectors.toList());
        int healthyInstanceCount = healthyInstance.size();
        if (healthyInstanceCount == 0) {
            return new RouteResult(instances.getInstances(), RouteResult.State.Next);
        }
        return new RouteResult(healthyInstance, RouteResult.State.Next);
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
    }

    public String getName() {
        return "recoverRouter";
    }

    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.AFTER;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        return true;
    }
}

