/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.nearby;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportClientTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportClientTask.class);
    private final Extensions extensions;
    private final String version;
    private final String clientHost;
    private final ValueContext shareContext;

    public ReportClientTask(Extensions extensions, ValueContext shareContext) {
        this.extensions = extensions;
        this.version = "1.2.2";
        this.clientHost = shareContext.getHost();
        this.shareContext = shareContext;
    }

    @Override
    public void run() {
        ReportClientResponse rsp = this.doReport(this.clientHost, this.version);
        if (null == rsp) {
            return;
        }
        LOG.debug("current client Region:{}, Zone:{}, Campus:{}", new Object[]{rsp.getRegion(), rsp.getZone(), rsp.getCampus()});
        this.shareContext.setValue(LocationLevel.region.name(), (Object)rsp.getRegion());
        this.shareContext.setValue(LocationLevel.zone.name(), (Object)rsp.getZone());
        this.shareContext.setValue(LocationLevel.campus.name(), (Object)rsp.getCampus());
        this.shareContext.notifyAllForLocationReady();
    }

    private ReportClientResponse doReport(String clientHost, String version) {
        ReportClientRequest req = new ReportClientRequest();
        req.setClientHost(clientHost);
        req.setVersion(version);
        ReportClientResponse rsp = null;
        try {
            rsp = this.extensions.getServerConnector().reportClient(req);
        }
        catch (PolarisException e) {
            LOG.warn("fail to report client info(clientHost={}, version={}), cause is {}", new Object[]{clientHost, version, e.getMessage()});
        }
        return rsp;
    }
}

