/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.nearby;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.nearby.NearbyRouterConfig;
import com.tencent.polaris.plugins.router.nearby.ReportClientTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class NearbyRouter
extends AbstractServiceRouter
implements PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NearbyRouter.class);
    private static final LocationLevel defaultMinLevel = LocationLevel.zone;
    private ValueContext valueContext;
    private ScheduledExecutorService reportClientExecutor;
    private NearbyRouterConfig config;
    private double healthyPercentToDegrade;
    long locationReadyTimeout;
    private final AtomicReference<Map<LocationLevel, String>> locationInfo = new AtomicReference();
    private static final String nearbyMetadataEnable = "internal-enable-nearby";

    public RouteResult router(RouteInfo routeInfo, ServiceInstances serviceInstances) throws PolarisException {
        LocationLevel maxLevel;
        LocationLevel minAvailableLevel = this.config.getMatchLevel();
        if (null == minAvailableLevel) {
            minAvailableLevel = defaultMinLevel;
        }
        LocationLevel minLevel = minAvailableLevel;
        if (null != routeInfo.getNextRouterInfo()) {
            if (null != routeInfo.getNextRouterInfo().getLocationLevel()) {
                minLevel = routeInfo.getNextRouterInfo().getLocationLevel();
            }
            if (null != routeInfo.getNextRouterInfo().getMinAvailableLevel()) {
                minAvailableLevel = routeInfo.getNextRouterInfo().getMinAvailableLevel();
            }
        }
        if (null == (maxLevel = this.config.getMaxMatchLevel())) {
            maxLevel = LocationLevel.all;
        }
        Map<LocationLevel, String> clientLocationInfo = this.locationInfo.get();
        if (minLevel.ordinal() >= maxLevel.ordinal()) {
            List<Instance> instances = this.selectInstances(serviceInstances, minAvailableLevel, clientLocationInfo);
            if (CollectionUtils.isEmpty(instances)) {
                throw new PolarisException(ErrorCode.LOCATION_MISMATCH, String.format("can not find any instance by level %s", minLevel.name()));
            }
            return new RouteResult(this.selectInstances(serviceInstances, minAvailableLevel, clientLocationInfo), RouteResult.State.Next);
        }
        CheckResult checkResult = new CheckResult();
        for (int i = minLevel.ordinal(); i <= maxLevel.ordinal(); ++i) {
            LocationLevel curLevel = LocationLevel.values()[i];
            checkResult = this.hasHealthyInstances(serviceInstances, routeInfo.getStatusDimensions(), curLevel, clientLocationInfo);
            checkResult.curLevel = curLevel;
            if (!CollectionUtils.isEmpty(checkResult.instances)) break;
            minAvailableLevel = curLevel;
        }
        if (CollectionUtils.isEmpty(checkResult.instances)) {
            throw new PolarisException(ErrorCode.LOCATION_MISMATCH, String.format("can not find any instance by level %s", checkResult.curLevel.name()));
        }
        if (!this.config.isEnableDegradeByUnhealthyPercent().booleanValue() || checkResult.curLevel == LocationLevel.all) {
            return new RouteResult(checkResult.instances, RouteResult.State.Next);
        }
        int healthyInstanceCount = checkResult.healthyInstanceCount;
        double actualHealthyPercent = (double)healthyInstanceCount / (double)serviceInstances.getInstances().size();
        if (actualHealthyPercent <= this.healthyPercentToDegrade) {
            LOG.debug("[shouldDegrade] enableDegradeByUnhealthyPercent = {},unhealthyPercentToDegrade={},healthyPercent={},isStrict={},matchLevel={}", new Object[]{this.config.isEnableDegradeByUnhealthyPercent(), this.config.getUnhealthyPercentToDegrade(), actualHealthyPercent, this.config.isStrictNearby(), checkResult.curLevel});
            RouteResult result = new RouteResult(checkResult.instances, RouteResult.State.Retry);
            result.getNextRouterInfo().setLocationLevel(this.nextLevel(checkResult.curLevel));
            result.getNextRouterInfo().setMinAvailableLevel(minAvailableLevel);
            return result;
        }
        return new RouteResult(checkResult.instances, RouteResult.State.Next);
    }

    private LocationLevel nextLevel(LocationLevel current) {
        if (current == LocationLevel.all) {
            return current;
        }
        return LocationLevel.values()[current.ordinal() + 1];
    }

    private CheckResult hasHealthyInstances(ServiceInstances svcInstances, Map<StatusDimension.Level, StatusDimension> dimensions, LocationLevel targetLevel, Map<LocationLevel, String> clientInfo) {
        String clientZone = "";
        String clientRegion = "";
        String clientCampus = "";
        if (null != clientInfo) {
            clientZone = clientInfo.get(LocationLevel.zone);
            clientRegion = clientInfo.get(LocationLevel.region);
            clientCampus = clientInfo.get(LocationLevel.campus);
        }
        CheckResult checkResult = new CheckResult();
        block5: for (Instance instance : svcInstances.getInstances()) {
            switch (targetLevel) {
                case zone: {
                    if (!clientZone.equals("") && !clientZone.equals(instance.getZone())) continue block5;
                    checkResult.instances.add(instance);
                    if (!Utils.isHealthyInstance((Instance)instance, dimensions)) continue block5;
                    ++checkResult.healthyInstanceCount;
                    continue block5;
                }
                case campus: {
                    if (!clientCampus.equals("") && !clientCampus.equals(instance.getCampus())) continue block5;
                    checkResult.instances.add(instance);
                    if (!Utils.isHealthyInstance((Instance)instance, dimensions)) continue block5;
                    ++checkResult.healthyInstanceCount;
                    continue block5;
                }
                case region: {
                    if (!clientRegion.equals("") && !clientRegion.equals(instance.getRegion())) continue block5;
                    checkResult.instances.add(instance);
                    if (!Utils.isHealthyInstance((Instance)instance, dimensions)) continue block5;
                    ++checkResult.healthyInstanceCount;
                    continue block5;
                }
            }
            checkResult.instances.add(instance);
            if (!Utils.isHealthyInstance((Instance)instance, dimensions)) continue;
            ++checkResult.healthyInstanceCount;
        }
        return checkResult;
    }

    private List<Instance> selectInstances(ServiceInstances svcInstances, LocationLevel targetLevel, Map<LocationLevel, String> clientInfo) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        String clientZone = "";
        String clientRegion = "";
        String clientCampus = "";
        if (null != clientInfo) {
            clientZone = clientInfo.get(LocationLevel.zone);
            clientRegion = clientInfo.get(LocationLevel.region);
            clientCampus = clientInfo.get(LocationLevel.campus);
        }
        block5: for (Instance instance : svcInstances.getInstances()) {
            switch (targetLevel) {
                case zone: {
                    if (!clientZone.equals("") && !clientZone.equals(instance.getZone())) continue block5;
                    instances.add(instance);
                    continue block5;
                }
                case campus: {
                    if (!clientCampus.equals("") && !clientCampus.equals(instance.getCampus())) continue block5;
                    instances.add(instance);
                    continue block5;
                }
                case region: {
                    if (!clientRegion.equals("") && !clientRegion.equals(instance.getRegion())) continue block5;
                    instances.add(instance);
                    continue block5;
                }
            }
            instances.add(instance);
        }
        return instances;
    }

    public String getName() {
        return "nearbyBasedRouter";
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return NearbyRouterConfig.class;
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.valueContext = ctx.getValueContext();
        NearbyRouterConfig config = (NearbyRouterConfig)ctx.getConfig().getConsumer().getServiceRouter().getPluginConfig(this.getName(), NearbyRouterConfig.class);
        if (config == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        this.config = config;
        LOG.debug("[init] config={}", (Object)this.config);
        this.locationReadyTimeout = (ctx.getConfig().getGlobal().getAPI().getReportInterval() + ctx.getConfig().getGlobal().getServerConnector().getConnectTimeout()) * (long)(ctx.getConfig().getGlobal().getAPI().getMaxRetryTimes() + 1);
        this.healthyPercentToDegrade = 1.0 - (double)config.getUnhealthyPercentToDegrade().intValue() / 100.0;
        if (this.config.isEnableReportLocalAddress().booleanValue()) {
            this.reportClientExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(this.getName()));
        }
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        if (null != this.reportClientExecutor) {
            this.reportClientExecutor.scheduleAtFixedRate(new ReportClientTask(extensions, this.valueContext), 0L, 60L, TimeUnit.SECONDS);
            LOG.info("reportClientExecutor has been started");
            this.ensureLocationReady();
        }
    }

    public void ensureLocationReady() throws PolarisException {
        if (!this.config.isStrictNearby().booleanValue()) {
            return;
        }
        try {
            this.valueContext.waitForLocationReady(this.locationReadyTimeout);
            this.refreshLocationInfo();
        }
        catch (InterruptedException e) {
            throw new PolarisException(ErrorCode.LOCATION_MISMATCH, "caller location not ready,and strict nearby is true.", (Throwable)e);
        }
    }

    private void refreshLocationInfo() {
        HashMap<LocationLevel, Object> clientLocationInfo = new HashMap<LocationLevel, Object>();
        for (LocationLevel key : LocationLevel.values()) {
            if (this.valueContext.getValue(key.name()) == null) continue;
            clientLocationInfo.put(key, this.valueContext.getValue(key.name()));
        }
        this.locationInfo.set(clientLocationInfo);
        LOG.debug("[refreshLocationInfo] locationInfo={}", clientLocationInfo);
    }

    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        if (!super.enable(routeInfo, dstSvcInfo)) {
            return false;
        }
        Map<LocationLevel, String> clientLocationInfo = this.locationInfo.get();
        if (MapUtils.isEmpty(clientLocationInfo)) {
            return false;
        }
        if (!dstSvcInfo.getMetadata().containsKey(nearbyMetadataEnable)) {
            return false;
        }
        return Boolean.parseBoolean((String)dstSvcInfo.getMetadata().get(nearbyMetadataEnable));
    }

    protected void doDestroy() {
        LOG.info("reportClientExecutor has been stopped");
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.reportClientExecutor});
    }

    private static class CheckResult {
        LocationLevel curLevel;
        int healthyInstanceCount;
        List<Instance> instances = new ArrayList<Instance>();

        private CheckResult() {
        }
    }
}

