/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.nearby;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;

public class ReportClientTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportClientTask.class);
    private final Extensions extensions;
    private final String version;
    private final String clientHost;
    private final ValueContext shareContext;

    public ReportClientTask(Extensions extensions, ValueContext shareContext) {
        this.extensions = extensions;
        this.version = "1.6.1";
        this.clientHost = shareContext.getHost();
        this.shareContext = shareContext;
    }

    @Override
    public void run() {
        ReportClientResponse rsp = this.doReport(this.clientHost, this.version);
        if (null == rsp) {
            return;
        }
        LOG.debug("current client Region:{}, Zone:{}, Campus:{}", new Object[]{rsp.getRegion(), rsp.getZone(), rsp.getCampus()});
        this.shareContext.setValue(LocationLevel.region.name(), (Object)rsp.getRegion());
        this.shareContext.setValue(LocationLevel.zone.name(), (Object)rsp.getZone());
        this.shareContext.setValue(LocationLevel.campus.name(), (Object)rsp.getCampus());
        this.shareContext.notifyAllForLocationReady();
    }

    private ReportClientResponse doReport(String clientHost, String version) {
        BaseEngine engine = BaseEngine.getEngine((ValueContext)this.shareContext);
        ReportClientRequest req = new ReportClientRequest();
        req.setClientHost(clientHost);
        req.setVersion(version);
        ReportClientResponse rsp = null;
        long start = System.currentTimeMillis();
        ServiceCallResult serviceCallResult = new ServiceCallResult();
        try {
            rsp = this.extensions.getServerConnector().reportClient(req);
            serviceCallResult.setRetStatus(RetStatus.RetSuccess);
            serviceCallResult.setRetCode(ErrorCode.Success.getCode());
        }
        catch (PolarisException e) {
            serviceCallResult.setRetStatus(RetStatus.RetFail);
            serviceCallResult.setRetCode(e.getCode().getCode());
            LOG.warn("fail to report client info(clientHost={}, version={}), cause is {}", new Object[]{clientHost, version, e.getMessage()});
        }
        long delay = System.currentTimeMillis() - start;
        serviceCallResult.setDelay(delay);
        if (null != engine) {
            engine.reportServerCall(serviceCallResult, req.getTargetServer(), "reportClient");
        }
        return rsp;
    }
}

