/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.rule;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.SubsetResource;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.rpc.RuleBasedRouterFailoverType;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.circuitbreak.client.api.DefaultCircuitBreakAPI;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.rule.PrioritySubsets;
import com.tencent.polaris.plugins.router.rule.RuleBasedRouterConfig;
import com.tencent.polaris.plugins.router.rule.RuleMatchType;
import com.tencent.polaris.plugins.router.rule.RuleStatus;
import com.tencent.polaris.plugins.router.rule.WeightedSubset;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;

public class RuleBasedRouter
extends AbstractServiceRouter
implements PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RuleBasedRouter.class);
    public static final String ROUTER_TYPE_RULE_BASED = "ruleRouter";
    public static final String ROUTER_ENABLED = "enabled";
    private Map<String, String> globalVariablesConfig;
    private RuleBasedRouterConfig routerConfig;

    private List<RoutingProto.Route> getRoutesFromRule(RouteInfo routeInfo, RuleMatchType ruleMatchType) throws PolarisException {
        if (ruleMatchType == RuleMatchType.destRouteRuleMatch) {
            if (null == routeInfo.getDestRouteRule() || null == routeInfo.getDestRouteRule().getRule()) {
                return null;
            }
            Object routing = routeInfo.getDestRouteRule().getRule();
            if (!(routing instanceof RoutingProto.Routing)) {
                throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "getRuleFilteredInstances param invalid, inbound routing must be instance of RoutingProto.Routing");
            }
            return ((RoutingProto.Routing)routing).getInboundsList();
        }
        if (null == routeInfo.getSourceRouteRule() || null == routeInfo.getSourceRouteRule().getRule()) {
            return null;
        }
        Object routing = routeInfo.getSourceRouteRule().getRule();
        if (!(routing instanceof RoutingProto.Routing)) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "getRuleFilteredInstances param invalid, outbound routing must be instance of RoutingProto.Routing");
        }
        return ((RoutingProto.Routing)routing).getOutboundsList();
    }

    private boolean matchSource(List<RoutingProto.Source> sources, Service sourceService, Map<String, String> trafficLabels, RuleMatchType ruleMatchType, Map<String, String> multiEnvRouterParamMap) {
        if (CollectionUtils.isEmpty(sources)) {
            return true;
        }
        boolean matched = true;
        for (RoutingProto.Source source : sources) {
            if (ruleMatchType == RuleMatchType.destRouteRuleMatch) {
                if (sourceService == null) {
                    if (!"*".equals(source.getNamespace().getValue()) || !"*".equals(source.getService().getValue())) {
                        matched = false;
                        continue;
                    }
                } else {
                    if (!"*".equals(source.getNamespace().getValue()) && !source.getNamespace().getValue().equals(sourceService.getNamespace())) {
                        matched = false;
                        continue;
                    }
                    if (!"*".equals(source.getService().getValue()) && !source.getService().getValue().equals(sourceService.getService())) {
                        matched = false;
                        continue;
                    }
                }
            }
            if (MapUtils.isEmpty((Map)source.getMetadataMap())) {
                matched = true;
                break;
            }
            if (sourceService == null) {
                matched = false;
                continue;
            }
            matched = RuleUtils.matchMetadata((Map)source.getMetadataMap(), trafficLabels, (boolean)true, multiEnvRouterParamMap, this.globalVariablesConfig);
            if (!matched) continue;
            break;
        }
        return matched;
    }

    private List<RoutingProto.Destination> filterAvailableDestinations(RouteInfo routeInfo, List<RoutingProto.Destination> destinations) {
        ArrayList<RoutingProto.Destination> availableSubsets = new ArrayList<RoutingProto.Destination>();
        ArrayList<RoutingProto.Destination> cbSubsets = new ArrayList<RoutingProto.Destination>();
        for (RoutingProto.Destination dest : destinations) {
            ServiceMetadata destService;
            ServiceKey serviceKey;
            SubsetResource resource;
            CheckResult check;
            if (dest == null || dest.getIsolate().getValue()) continue;
            if (StringUtils.isNotBlank((String)dest.getName().getValue()) && !(check = DefaultCircuitBreakAPI.check((Resource)(resource = new SubsetResource(serviceKey = new ServiceKey((destService = routeInfo.getDestService()).getNamespace(), destService.getService()), dest.getName().getValue(), dest.getMetadataMap())), (Extensions)this.extensions)).isPass()) {
                cbSubsets.add(dest);
                continue;
            }
            availableSubsets.add(dest);
        }
        if (availableSubsets.isEmpty()) {
            return cbSubsets;
        }
        return availableSubsets;
    }

    private List<Instance> getRuleFilteredInstances(RouteInfo routeInfo, ServiceInstances instances, RuleMatchType ruleMatchType, MatchStatus matchStatus) throws PolarisException {
        List<RoutingProto.Route> routes = this.getRoutesFromRule(routeInfo, ruleMatchType);
        if (CollectionUtils.isEmpty(routes)) {
            return Collections.emptyList();
        }
        HashMap<String, String> multiEnvRouterParamMap = new HashMap<String, String>();
        for (RoutingProto.Route route : routes) {
            if (route == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getRuleFilteredInstances, route:{}", (Object)route);
            }
            Map trafficLabels = routeInfo.getRouterMetadata(ROUTER_TYPE_RULE_BASED);
            boolean sourceMatched = this.matchSource(route.getSourcesList(), (Service)routeInfo.getSourceService(), trafficLabels, ruleMatchType, multiEnvRouterParamMap);
            if (!sourceMatched) continue;
            matchStatus.matched = true;
            HashMap<Integer, PrioritySubsets> subsetsMap = new HashMap<Integer, PrioritySubsets>();
            int smallestPriority = -1;
            List<RoutingProto.Destination> destinations = this.filterAvailableDestinations(routeInfo, route.getDestinationsList());
            for (RoutingProto.Destination dest : destinations) {
                boolean populated;
                if (ruleMatchType == RuleMatchType.sourceRouteRuleMatch && (!"*".equals(dest.getNamespace().getValue()) && !dest.getNamespace().getValue().equals(routeInfo.getDestService().getNamespace()) || !"*".equals(dest.getService().getValue()) && !dest.getService().getValue().equals(routeInfo.getDestService().getService())) || dest.getWeight().getValue() == 0 || !(populated = this.populateSubsetsFromDest(instances, dest, subsetsMap, multiEnvRouterParamMap))) continue;
                int priority = dest.getPriority().getValue();
                if (smallestPriority >= 0 && smallestPriority <= priority) continue;
                smallestPriority = priority;
            }
            if (MapUtils.isEmpty(subsetsMap)) continue;
            return this.selectInstances(routeInfo, (PrioritySubsets)subsetsMap.get(smallestPriority));
        }
        return Collections.emptyList();
    }

    private boolean populateSubsetsFromDest(ServiceInstances instances, RoutingProto.Destination dest, Map<Integer, PrioritySubsets> subsetsMap, Map<String, String> multiEnvRouterParamMap) {
        List oriInstances = instances.getInstances();
        ArrayList<Instance> filteredInstances = new ArrayList<Instance>();
        for (Instance ins : oriInstances) {
            if (!RuleUtils.matchMetadata((Map)dest.getMetadataMap(), (Map)ins.getMetadata(), (boolean)false, multiEnvRouterParamMap, this.globalVariablesConfig)) continue;
            filteredInstances.add(ins);
        }
        if (CollectionUtils.isEmpty(filteredInstances)) {
            return false;
        }
        int priority = dest.getPriority().getValue();
        int weight = dest.getWeight().getValue();
        PrioritySubsets weightedSubsets = subsetsMap.get(priority);
        if (weightedSubsets == null) {
            PrioritySubsets prioritySubsets = new PrioritySubsets();
            WeightedSubset weightedSubset = new WeightedSubset(dest);
            weightedSubset.setInstances(filteredInstances);
            weightedSubset.setWeight(weight);
            prioritySubsets.setSubsets(new ArrayList<WeightedSubset>(Collections.singletonList(weightedSubset)));
            prioritySubsets.setTotalWeight(weight);
            subsetsMap.put(priority, prioritySubsets);
        } else {
            WeightedSubset weightedSubset = new WeightedSubset(dest);
            weightedSubset.setInstances(filteredInstances);
            weightedSubset.setWeight(weight);
            weightedSubsets.getSubsets().add(weightedSubset);
            weightedSubsets.setTotalWeight(weightedSubsets.getTotalWeight() + weight);
        }
        return true;
    }

    private List<Instance> selectInstances(RouteInfo routeInfo, PrioritySubsets weightedSubsets) {
        if (weightedSubsets.getSubsets().size() == 1) {
            return weightedSubsets.getSubsets().get(0).getInstances();
        }
        Random random = new Random();
        long weight = random.nextInt(weightedSubsets.getTotalWeight());
        int matchedRange = -1;
        for (WeightedSubset weightedSubset : weightedSubsets.getSubsets()) {
            if ((weight -= weightedSubset.getWeight()) >= 0L) continue;
            RoutingProto.Destination destination = weightedSubset.getDestination();
            routeInfo.setSubsetName(destination.getName().getValue());
            routeInfo.setSubsetMetadata(destination.getMetadataMap());
            return weightedSubset.getInstances();
        }
        return Collections.emptyList();
    }

    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) {
        RuleStatus ruleStatus = RuleStatus.noRule;
        List<Instance> destFilteredInstances = null;
        List<Instance> sourceFilteredInstances = null;
        MatchStatus matchStatus = new MatchStatus();
        if (routeInfo.getDestRouteRule() != null) {
            destFilteredInstances = this.getRuleFilteredInstances(routeInfo, instances, RuleMatchType.destRouteRuleMatch, matchStatus);
            if (!destFilteredInstances.isEmpty()) {
                ruleStatus = RuleStatus.destRuleSucc;
            }
            if (destFilteredInstances.isEmpty() && matchStatus.matched) {
                ruleStatus = RuleStatus.destRuleFail;
            }
        }
        if (ruleStatus == RuleStatus.noRule && routeInfo.getSourceRouteRule() != null) {
            sourceFilteredInstances = this.getRuleFilteredInstances(routeInfo, instances, RuleMatchType.sourceRouteRuleMatch, matchStatus);
            ruleStatus = sourceFilteredInstances.isEmpty() ? RuleStatus.sourceRuleFail : RuleStatus.sourceRuleSucc;
        }
        switch (ruleStatus) {
            case sourceRuleSucc: {
                return new RouteResult(sourceFilteredInstances, RouteResult.State.Next);
            }
            case destRuleSucc: {
                return new RouteResult(destFilteredInstances, RouteResult.State.Next);
            }
        }
        LOG.warn("route rule not match, rule status: {}, not matched source {}", (Object)ruleStatus, (Object)routeInfo.getSourceService());
        RuleBasedRouterFailoverType failoverType = routeInfo.getRuleBasedRouterFailoverType();
        if (failoverType == null) {
            failoverType = this.routerConfig.getFailoverType();
        }
        if (failoverType == RuleBasedRouterFailoverType.none) {
            return new RouteResult(Collections.emptyList(), RouteResult.State.Next);
        }
        return new RouteResult(instances.getInstances(), RouteResult.State.Next);
    }

    private List<Instance> getHealthyInstances(List<Instance> instances) {
        ArrayList<Instance> healthyInstances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            if (!instance.isHealthy()) continue;
            healthyInstances.add(instance);
        }
        return healthyInstances;
    }

    private List<Instance> getHealthyInstancesOrAllIfAllDead(List<Instance> instances) {
        List<Instance> healthyInstances = this.getHealthyInstances(instances);
        if (!healthyInstances.isEmpty()) {
            LOG.info("getHealthyInstancesOrAllIfAllDead found {} healthy instances, return heathy ones", (Object)healthyInstances.size());
            return healthyInstances;
        }
        return instances;
    }

    private List<Instance> getInstancesOfEnv(ServiceInstances serviceInstances, String env) {
        List instances = serviceInstances.getInstances();
        ArrayList<Instance> retInstances = new ArrayList<Instance>();
        for (Instance ins : instances) {
            if (!env.equals(ins.getMetadata().get("env"))) continue;
            retInstances.add(ins);
        }
        return retInstances;
    }

    public String getName() {
        return "ruleBasedRouter";
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return RuleBasedRouterConfig.class;
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.globalVariablesConfig = ctx.getConfig().getGlobal().getSystem().getVariables();
        this.routerConfig = (RuleBasedRouterConfig)ctx.getConfig().getConsumer().getServiceRouter().getPluginConfig(this.getName(), RuleBasedRouterConfig.class);
    }

    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        String enabled;
        if (!super.enable(routeInfo, dstSvcInfo)) {
            return false;
        }
        if (routeInfo.getSourceService() == null) {
            return false;
        }
        Map routerMetadata = routeInfo.getRouterMetadata(ROUTER_TYPE_RULE_BASED);
        if (MapUtils.isNotEmpty((Map)routerMetadata) && StringUtils.isNotBlank((String)(enabled = (String)routerMetadata.get(ROUTER_ENABLED))) && !Boolean.parseBoolean(enabled)) {
            return false;
        }
        List<RoutingProto.Route> dstRoutes = this.getRoutesFromRule(routeInfo, RuleMatchType.destRouteRuleMatch);
        List<RoutingProto.Route> srcRoutes = this.getRoutesFromRule(routeInfo, RuleMatchType.sourceRouteRuleMatch);
        return !CollectionUtils.isEmpty(dstRoutes) || !CollectionUtils.isEmpty(srcRoutes);
    }

    void setRouterConfig(RuleBasedRouterConfig routerConfig) {
        this.routerConfig = routerConfig;
    }

    private static class MatchStatus {
        boolean matched;

        private MatchStatus() {
        }
    }
}

