/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.rule;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.client.pb.ModelProto;
import com.tencent.polaris.client.pb.RoutingProto;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.rule.PrioritySubsets;
import com.tencent.polaris.plugins.router.rule.RuleMatchType;
import com.tencent.polaris.plugins.router.rule.RuleStatus;
import com.tencent.polaris.plugins.router.rule.WeightedSubset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedRouter
extends AbstractServiceRouter {
    private static final Logger LOG = LoggerFactory.getLogger(RuleBasedRouter.class);
    private Map<String, String> globalVariablesConfig;

    private List<RoutingProto.Route> getRoutesFromRule(RouteInfo routeInfo, RuleMatchType ruleMatchType) throws PolarisException {
        if (ruleMatchType == RuleMatchType.destRouteRuleMatch) {
            if (null == routeInfo.getDestRouteRule() || null == routeInfo.getDestRouteRule().getRule()) {
                return null;
            }
            Object routing = routeInfo.getDestRouteRule().getRule();
            if (!(routing instanceof RoutingProto.Routing)) {
                throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "getRuleFilteredInstances param invalid, inbound routing must be instance of RoutingProto.Routing");
            }
            return ((RoutingProto.Routing)routing).getInboundsList();
        }
        if (null == routeInfo.getSourceRouteRule() || null == routeInfo.getSourceRouteRule().getRule()) {
            return null;
        }
        Object routing = routeInfo.getSourceRouteRule().getRule();
        if (!(routing instanceof RoutingProto.Routing)) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "getRuleFilteredInstances param invalid, outbound routing must be instance of RoutingProto.Routing");
        }
        return ((RoutingProto.Routing)routing).getOutboundsList();
    }

    private boolean matchSource(List<RoutingProto.Source> sources, ServiceMetadata sourceService, RuleMatchType ruleMatchType, Map<String, String> multiEnvRouterParamMap) {
        if (CollectionUtils.isEmpty(sources)) {
            return true;
        }
        boolean matched = true;
        for (RoutingProto.Source source : sources) {
            if (ruleMatchType == RuleMatchType.destRouteRuleMatch) {
                if (sourceService == null) {
                    if (!"*".equals(source.getNamespace().getValue()) || !"*".equals(source.getService().getValue())) {
                        matched = false;
                        continue;
                    }
                } else {
                    if (!"*".equals(source.getNamespace().getValue()) && !source.getNamespace().getValue().equals(sourceService.getNamespace())) {
                        matched = false;
                        continue;
                    }
                    if (!"*".equals(source.getService().getValue()) && !source.getService().getValue().equals(sourceService.getService())) {
                        matched = false;
                        continue;
                    }
                }
            }
            if (MapUtils.isEmpty((Map)source.getMetadataMap())) {
                matched = true;
                break;
            }
            if (sourceService == null) {
                matched = false;
                continue;
            }
            matched = this.matchMetadata(source.getMetadataMap(), sourceService.getMetadata(), true, multiEnvRouterParamMap);
            if (!matched) continue;
            break;
        }
        return matched;
    }

    private boolean matchMetadata(Map<String, ModelProto.MatchString> ruleMeta, Map<String, String> destMeta, boolean isMatchSource, Map<String, String> multiEnvRouterParamMap) {
        if (MapUtils.isEmpty(ruleMeta)) {
            return true;
        }
        if (ruleMeta.containsKey("*")) {
            return true;
        }
        if (MapUtils.isEmpty(destMeta)) {
            return false;
        }
        boolean allMetaMatched = true;
        int matchNum = 0;
        for (Map.Entry<String, ModelProto.MatchString> entry : ruleMeta.entrySet()) {
            String ruleMetaKey = entry.getKey();
            ModelProto.MatchString ruleMetaValue = entry.getValue();
            if (RuleUtils.isMatchAllValue((ModelProto.MatchString)ruleMetaValue)) {
                ++matchNum;
                continue;
            }
            if (destMeta.containsKey(ruleMetaKey)) {
                ++matchNum;
                if (!ruleMetaValue.hasValue() && ruleMetaValue.getValueType() != ModelProto.MatchString.ValueType.PARAMETER) continue;
                String destMetaValue = destMeta.get(ruleMetaKey);
                allMetaMatched = this.isAllMetaMatched(isMatchSource, true, ruleMetaKey, ruleMetaValue, destMetaValue, multiEnvRouterParamMap);
            }
            if (allMetaMatched) continue;
            break;
        }
        if (matchNum == 0) {
            allMetaMatched = false;
        }
        return allMetaMatched;
    }

    private boolean isAllMetaMatched(boolean isMatchSource, boolean allMetaMatched, String ruleMetaKey, ModelProto.MatchString ruleMetaValue, String destMetaValue, Map<String, String> multiEnvRouterParamMap) {
        allMetaMatched = ruleMetaValue.getType() == ModelProto.MatchString.MatchStringType.REGEX ? this.matchValueByValueType(isMatchSource, true, ruleMetaKey, ruleMetaValue, destMetaValue, multiEnvRouterParamMap) : this.matchValueByValueType(isMatchSource, false, ruleMetaKey, ruleMetaValue, destMetaValue, multiEnvRouterParamMap);
        return allMetaMatched;
    }

    private boolean matchValueByValueType(boolean isMatchSource, boolean isRegex, String ruleMetaKey, ModelProto.MatchString ruleMetaValue, String destMetaValue, Map<String, String> multiEnvRouterParamMap) {
        boolean allMetaMatched = true;
        switch (ruleMetaValue.getValueType()) {
            case PARAMETER: {
                if (isMatchSource) {
                    multiEnvRouterParamMap.put(ruleMetaKey, destMetaValue);
                    break;
                }
                if (!multiEnvRouterParamMap.containsKey(ruleMetaKey)) {
                    allMetaMatched = false;
                    break;
                }
                String ruleValue = multiEnvRouterParamMap.get(ruleMetaKey);
                allMetaMatched = this.matchValue(isRegex, destMetaValue, ruleValue);
                break;
            }
            case VARIABLE: {
                if (this.globalVariablesConfig.containsKey(ruleMetaKey)) {
                    String ruleValue = this.globalVariablesConfig.get(ruleMetaKey);
                    allMetaMatched = this.matchValue(isRegex, destMetaValue, ruleValue);
                    break;
                }
                String key = ruleMetaValue.getValue().getValue();
                if (!System.getenv().containsKey(key)) {
                    allMetaMatched = false;
                } else {
                    String value = System.getenv(key);
                    allMetaMatched = this.matchValue(isRegex, destMetaValue, value);
                }
                if (System.getenv().containsKey(key) && System.getenv(key).equals(destMetaValue)) break;
                allMetaMatched = false;
                break;
            }
            default: {
                allMetaMatched = this.matchValue(isRegex, destMetaValue, ruleMetaValue.getValue().getValue());
            }
        }
        return allMetaMatched;
    }

    private boolean matchValue(boolean isRegex, String destMetaValue, String ruleValue) {
        boolean allMetaMatched = true;
        if (isRegex) {
            boolean match = Utils.regMatch((String)ruleValue, (String)destMetaValue);
            if (!match) {
                allMetaMatched = false;
            }
        } else if (!destMetaValue.equals(ruleValue)) {
            allMetaMatched = false;
        }
        return allMetaMatched;
    }

    private List<Instance> getRuleFilteredInstances(RouteInfo routeInfo, ServiceInstances instances, RuleMatchType ruleMatchType) throws PolarisException {
        List<RoutingProto.Route> routes = this.getRoutesFromRule(routeInfo, ruleMatchType);
        if (CollectionUtils.isEmpty(routes)) {
            return Collections.emptyList();
        }
        HashMap<String, String> multiEnvRouterParamMap = new HashMap<String, String>();
        for (RoutingProto.Route route : routes) {
            boolean sourceMatched;
            if (route == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getRuleFilteredInstances, route:{}", (Object)route.toString());
            }
            if (!(sourceMatched = this.matchSource(route.getSourcesList(), routeInfo.getSourceService(), ruleMatchType, multiEnvRouterParamMap))) continue;
            HashMap<Integer, PrioritySubsets> subsetsMap = new HashMap<Integer, PrioritySubsets>();
            int smallestPriority = -1;
            for (RoutingProto.Destination dest : route.getDestinationsList()) {
                boolean populated;
                if (dest == null || ruleMatchType == RuleMatchType.sourceRouteRuleMatch && (!"*".equals(dest.getNamespace().getValue()) && !dest.getNamespace().getValue().equals(routeInfo.getDestService().getNamespace()) || !"*".equals(dest.getService().getValue()) && !dest.getService().getValue().equals(routeInfo.getDestService().getService())) || dest.getWeight().getValue() == 0 || !(populated = this.populateSubsetsFromDest(instances, dest, subsetsMap, multiEnvRouterParamMap))) continue;
                int priority = dest.getPriority().getValue();
                if (smallestPriority >= 0 && smallestPriority <= priority) continue;
                smallestPriority = priority;
            }
            if (MapUtils.isEmpty(subsetsMap)) continue;
            return this.selectInstances(routeInfo, (PrioritySubsets)subsetsMap.get(smallestPriority));
        }
        return Collections.emptyList();
    }

    private boolean populateSubsetsFromDest(ServiceInstances instances, RoutingProto.Destination dest, Map<Integer, PrioritySubsets> subsetsMap, Map<String, String> multiEnvRouterParamMap) {
        List oriInstances = instances.getInstances();
        ArrayList<Instance> filteredInstances = new ArrayList<Instance>();
        for (Instance ins : oriInstances) {
            if (!this.matchMetadata(dest.getMetadataMap(), ins.getMetadata(), false, multiEnvRouterParamMap)) continue;
            filteredInstances.add(ins);
        }
        if (CollectionUtils.isEmpty(filteredInstances)) {
            return false;
        }
        int priority = dest.getPriority().getValue();
        int weight = dest.getWeight().getValue();
        PrioritySubsets weightedSubsets = subsetsMap.get(priority);
        if (weightedSubsets == null) {
            PrioritySubsets prioritySubsets = new PrioritySubsets();
            WeightedSubset weightedSubset = new WeightedSubset();
            weightedSubset.setInstances(filteredInstances);
            weightedSubset.setWeight(weight);
            prioritySubsets.setSubsets(new ArrayList<WeightedSubset>(Collections.singletonList(weightedSubset)));
            prioritySubsets.setTotalWeight(weight);
            subsetsMap.put(priority, prioritySubsets);
        } else {
            WeightedSubset weightedSubset = new WeightedSubset();
            weightedSubset.setInstances(filteredInstances);
            weightedSubset.setWeight(weight);
            weightedSubsets.getSubsets().add(weightedSubset);
            weightedSubsets.setTotalWeight(weightedSubsets.getTotalWeight() + weight);
        }
        return true;
    }

    private List<Instance> selectInstances(RouteInfo routeInfo, PrioritySubsets weightedSubsets) {
        if (weightedSubsets.getSubsets().size() == 1) {
            return weightedSubsets.getSubsets().get((int)0).instances;
        }
        Random random = new Random();
        long weight = random.nextInt(weightedSubsets.getTotalWeight());
        int matchedRange = -1;
        for (WeightedSubset weightedSubset : weightedSubsets.getSubsets()) {
            if ((weight -= weightedSubset.getWeight()) >= 0L) continue;
            return weightedSubset.getInstances();
        }
        return Collections.emptyList();
    }

    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) {
        List<Instance> destFilteredInstances = null;
        List<Instance> sourceFilteredInstances = null;
        RuleStatus ruleStatus = routeInfo.getDestRouteRule() != null ? ((destFilteredInstances = this.getRuleFilteredInstances(routeInfo, instances, RuleMatchType.destRouteRuleMatch)).isEmpty() ? RuleStatus.destRuleFail : RuleStatus.destRuleSucc) : ((sourceFilteredInstances = this.getRuleFilteredInstances(routeInfo, instances, RuleMatchType.sourceRouteRuleMatch)).isEmpty() ? RuleStatus.sourceRuleFail : RuleStatus.sourceRuleSucc);
        switch (ruleStatus) {
            case sourceRuleSucc: {
                return new RouteResult(sourceFilteredInstances, RouteResult.State.Next);
            }
            case destRuleSucc: {
                return new RouteResult(destFilteredInstances, RouteResult.State.Next);
            }
        }
        LOG.error("route rule not match, rule status: {}, not matched source {}", (Object)ruleStatus, (Object)routeInfo.getSourceService());
        return new RouteResult(Collections.emptyList(), RouteResult.State.Next);
    }

    private List<Instance> getHealthyInstances(List<Instance> instances) {
        ArrayList<Instance> healthyInstances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            if (!instance.isHealthy()) continue;
            healthyInstances.add(instance);
        }
        return healthyInstances;
    }

    private List<Instance> getHealthyInstancesOrAllIfAllDead(List<Instance> instances) {
        List<Instance> healthyInstances = this.getHealthyInstances(instances);
        if (!healthyInstances.isEmpty()) {
            LOG.info("getHealthyInstancesOrAllIfAllDead found {} healthy instances, return heathy ones", (Object)healthyInstances.size());
            return healthyInstances;
        }
        return instances;
    }

    private List<Instance> getInstancesOfEnv(ServiceInstances serviceInstances, String env) {
        List instances = serviceInstances.getInstances();
        ArrayList<Instance> retInstances = new ArrayList<Instance>();
        for (Instance ins : instances) {
            if (!env.equals(ins.getMetadata().get("env"))) continue;
            retInstances.add(ins);
        }
        return retInstances;
    }

    public String getName() {
        return "ruleBasedRouter";
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.globalVariablesConfig = ctx.getConfig().getGlobal().getSystem().getVariables();
    }

    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        if (routeInfo.getSourceService() == null) {
            return false;
        }
        List<RoutingProto.Route> dstRoutes = this.getRoutesFromRule(routeInfo, RuleMatchType.destRouteRuleMatch);
        List<RoutingProto.Route> srcRoutes = this.getRoutesFromRule(routeInfo, RuleMatchType.sourceRouteRuleMatch);
        return !CollectionUtils.isEmpty(dstRoutes) || !CollectionUtils.isEmpty(srcRoutes);
    }
}

