/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.router.set;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class SetRouter
extends AbstractServiceRouter {
    private static final Logger LOG = LoggerFactory.getLogger(SetRouter.class);

    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        Map metadata;
        String setEnabled;
        if (routeInfo.getDestService() != null && MapUtils.isNotEmpty((Map)routeInfo.getDestService().getMetadata()) && "Y".equals(setEnabled = (String)(metadata = routeInfo.getDestService().getMetadata()).get("internal-enable-set"))) {
            routeInfo.disableRouter("nearbyBasedRouter");
            String destSetName = (String)metadata.get("internal-set-name");
            List filteredResult = instances.getInstances().stream().filter(instance -> this.calleeSetEnabled((Instance)instance) && this.setIsAllSame((Instance)instance, destSetName)).collect(Collectors.toList());
            LOG.debug("[doSetRouter] destinationSet result:{},{}", (Object)destSetName, (Object)filteredResult.size());
            return new RouteResult(filteredResult, RouteResult.State.Next);
        }
        if (routeInfo.getDestService() != null && MapUtils.isNotEmpty((Map)routeInfo.getDestService().getMetadata()) && "Y".equals(setEnabled = (String)(metadata = routeInfo.getDestService().getMetadata()).get("internal-enable-set"))) {
            String sourceSetName = (String)metadata.get("internal-set-name");
            boolean calleeSetEnabled = instances.getInstances().stream().anyMatch(instance -> this.calleeSetEnabled((Instance)instance) && this.setNameIsSame((Instance)instance, sourceSetName));
            LOG.debug("[doSetRouter] calleeSetEnabled={}", (Object)calleeSetEnabled);
            if (!calleeSetEnabled) {
                return new RouteResult(instances.getInstances(), RouteResult.State.Next);
            }
            routeInfo.disableRouter("nearbyBasedRouter");
            boolean callIsLikeMatch = this.isLikeMatch(sourceSetName);
            LOG.debug("[doSetRouter] callIsLikeMatch={}", (Object)callIsLikeMatch);
            if (!callIsLikeMatch) {
                List filteredResult = instances.getInstances().stream().filter(instance -> this.setIsAllSame((Instance)instance, sourceSetName)).collect(Collectors.toList());
                LOG.debug("[doSetRouter] allMatch result:{},{}", (Object)sourceSetName, (Object)filteredResult.size());
                if (CollectionUtils.isNotEmpty(filteredResult)) {
                    return new RouteResult(filteredResult, RouteResult.State.Next);
                }
                filteredResult = instances.getInstances().stream().filter(instance -> this.setIsSameArea((Instance)instance, sourceSetName) && this.groupIsLike((Instance)instance)).collect(Collectors.toList());
                return new RouteResult(filteredResult, RouteResult.State.Next);
            }
            List filteredResult = instances.getInstances().stream().filter(instance -> this.setIsSameArea((Instance)instance, sourceSetName)).collect(Collectors.toList());
            LOG.debug("[doSetRouter] likeMatch result:{},{}", (Object)sourceSetName, (Object)filteredResult.size());
            return new RouteResult(filteredResult, RouteResult.State.Next);
        }
        return new RouteResult(instances.getInstances(), RouteResult.State.Next);
    }

    private boolean setIsAllSame(Instance instance, String setName) {
        return instance.getMetadata() != null && setName.equals(instance.getMetadata().get("internal-set-name"));
    }

    public boolean groupIsLike(Instance instance) {
        String calleeSet = null;
        if (instance.getMetadata() != null) {
            calleeSet = (String)instance.getMetadata().get("internal-set-name");
        }
        return this.isLikeMatch(calleeSet);
    }

    private boolean isLikeMatch(String callSet) {
        if (callSet != null) {
            String[] callSetTmp = callSet.split("\\.");
            return callSetTmp.length == 3 && "*".equals(callSetTmp[2]);
        }
        return false;
    }

    private boolean calleeSetEnabled(Instance instance) {
        return instance.getMetadata() != null && "Y".equals(instance.getMetadata().get("internal-enable-set"));
    }

    private boolean setIsSameArea(Instance instance, String callSet) {
        String calleeSet = null;
        if (instance.getMetadata() != null) {
            calleeSet = (String)instance.getMetadata().get("internal-set-name");
        }
        if (callSet == null || calleeSet == null) {
            return false;
        }
        String[] callSetTmp = callSet.split("\\.");
        String[] calleeSetTmp = calleeSet.split("\\.");
        if (calleeSetTmp.length > 2 && callSetTmp.length > 2) {
            return calleeSetTmp[0].equals(callSetTmp[0]) && calleeSetTmp[1].equals(callSetTmp[1]);
        }
        return false;
    }

    private boolean setNameIsSame(Instance instance, String callerSet) {
        String calleeSet = null;
        if (instance.getMetadata() != null) {
            calleeSet = (String)instance.getMetadata().get("internal-set-name");
        }
        if (callerSet == null || calleeSet == null) {
            return false;
        }
        String[] callSetTmp = callerSet.split("\\.");
        String[] calleeSetTmp = calleeSet.split("\\.");
        if (calleeSetTmp.length > 0 && callSetTmp.length > 0) {
            return calleeSetTmp[0].equals(callSetTmp[0]);
        }
        return false;
    }

    public String getName() {
        return "setRouter";
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
    }

    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        return super.enable(routeInfo, dstSvcInfo);
    }
}

