/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.common.api;

import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallStatCollector
implements ServiceCallResultListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCallStatCollector.class);
    private Collection<Plugin> statPlugins;
    private final AtomicBoolean init = new AtomicBoolean(false);

    public void init(SDKContext context) {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        this.statPlugins = context.getPlugins().getPlugins(PluginTypes.STAT_REPORTER.getBaseType());
    }

    public void onServiceCallResult(InstanceGauge result) {
        if (null == this.statPlugins) {
            return;
        }
        try {
            for (Plugin statPlugin : this.statPlugins) {
                if (!(statPlugin instanceof StatReporter)) continue;
                ((StatReporter)statPlugin).reportStat(ServiceCallStatCollector.convert(result));
            }
        }
        catch (Exception ex) {
            LOG.info("service call report encountered exception, e: {}", (Object)ex.getMessage());
        }
    }

    public void destroy() {
        if (!this.init.compareAndSet(true, false)) {
            return;
        }
        if (null == this.statPlugins) {
            return;
        }
        for (Plugin statPlugin : this.statPlugins) {
            statPlugin.destroy();
        }
        this.statPlugins = null;
    }

    private static StatInfo convert(InstanceGauge result) {
        StatInfo statInfo = new StatInfo();
        statInfo.setRouterGauge(result);
        return statInfo;
    }
}

