/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.tencent.polaris.api.plugin.stat.CircuitBreakGauge;
import com.tencent.polaris.api.plugin.stat.RateLimitGauge;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.plugins.stat.common.model.AbstractSignatureStatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.StatMetric;
import com.tencent.polaris.plugins.stat.common.model.StatRevisionMetric;
import com.tencent.polaris.plugins.stat.common.model.SystemMetricModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import shade.polaris.io.prometheus.client.Gauge;

public class CommonHandler {
    public static final int DEFAULT_INTERVAL_MILLI = 30000;
    public static final int REVISION_MAX_SCOPE = 2;
    public static final String PUSH_GROUP_KEY = "instance";
    public static final String PUSH_DEFAULT_JOB_NAME = "polaris-client";

    public static void putDataFromContainerInOrder(Map<String, Gauge> sampleMapping, AbstractSignatureStatInfoCollector<?, ? extends StatMetric> collector, long currentRevision, String[] order) {
        Collection values = collector.getCollectedValues();
        for (StatMetric s : values) {
            Gauge.Child child;
            Gauge gauge = sampleMapping.get(s.getMetricName());
            if (null == gauge) continue;
            if (s instanceof StatRevisionMetric) {
                StatRevisionMetric rs = (StatRevisionMetric)s;
                if (rs.getRevision() < currentRevision - 2L) {
                    gauge.remove(CommonHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    collector.getMetricContainer().remove(s.getSignature());
                    continue;
                }
                if (rs.getRevision() < currentRevision) {
                    gauge.remove(CommonHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    Gauge.Child child2 = (Gauge.Child)gauge.labels(CommonHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    if (null == child2) continue;
                    child2.set(0.0);
                    continue;
                }
            }
            if (null == (child = (Gauge.Child)gauge.labels(CommonHandler.getOrderedMetricLabelValues(s.getLabels(), order)))) continue;
            child.set(s.getValue());
        }
    }

    public static String[] getOrderedMetricLabelValues(Map<String, String> labels, String[] orderedKey) {
        String[] orderValue = new String[orderedKey.length];
        for (int i = 0; i < orderedKey.length; ++i) {
            orderValue[i] = labels.getOrDefault(orderedKey[i], "__NULL__");
        }
        return orderValue;
    }

    public static Map<String, String> convertInsGaugeToLabels(InstanceGauge insGauge, String sdkIP) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block28: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    CommonHandler.addLabel(labelName, insGauge.getNamespace(), labels);
                    continue block28;
                }
                case "callee_service": {
                    CommonHandler.addLabel(labelName, insGauge.getService(), labels);
                    continue block28;
                }
                case "callee_method": {
                    CommonHandler.addLabel(labelName, insGauge.getMethod(), labels);
                    continue block28;
                }
                case "callee_subset": {
                    CommonHandler.addLabel(labelName, insGauge.getSubset(), labels);
                    continue block28;
                }
                case "callee_instance": {
                    CommonHandler.addLabel(labelName, CommonHandler.buildAddress(insGauge.getHost(), insGauge.getPort()), labels);
                    continue block28;
                }
                case "callee_result_code": {
                    String retCodeStr = null == insGauge.getRetCode() ? null : insGauge.getRetCode().toString();
                    CommonHandler.addLabel(labelName, retCodeStr, labels);
                    continue block28;
                }
                case "caller_labels": {
                    CommonHandler.addLabel(labelName, insGauge.getLabels(), labels);
                    continue block28;
                }
                case "caller_namespace": {
                    String namespace = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getNamespace();
                    CommonHandler.addLabel(labelName, namespace, labels);
                    continue block28;
                }
                case "caller_service": {
                    String serviceName = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getService();
                    CommonHandler.addLabel(labelName, serviceName, labels);
                    continue block28;
                }
                case "callee_result": {
                    String retStatusStr = null == insGauge.getRetStatus() ? null : insGauge.getRetStatus().getDesc();
                    CommonHandler.addLabel(labelName, retStatusStr, labels);
                    continue block28;
                }
                case "caller_ip": {
                    String callerIp = Objects.isNull(insGauge.getCallerIp()) ? sdkIP : insGauge.getCallerIp();
                    CommonHandler.addLabel(labelName, callerIp, labels);
                    continue block28;
                }
                case "rule_name": {
                    String ruleName = Objects.isNull(insGauge.getRuleName()) ? null : insGauge.getRuleName();
                    CommonHandler.addLabel(labelName, ruleName, labels);
                    continue block28;
                }
            }
        }
        return labels;
    }

    public static Map<String, String> convertRateLimitGaugeToLabels(RateLimitGauge rateLimitGauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    CommonHandler.addLabel(labelName, rateLimitGauge.getNamespace(), labels);
                    continue block14;
                }
                case "callee_service": {
                    CommonHandler.addLabel(labelName, rateLimitGauge.getService(), labels);
                    continue block14;
                }
                case "callee_method": {
                    CommonHandler.addLabel(labelName, rateLimitGauge.getMethod(), labels);
                    continue block14;
                }
                case "caller_labels": {
                    CommonHandler.addLabel(labelName, rateLimitGauge.getLabels(), labels);
                    continue block14;
                }
                case "rule_name": {
                    CommonHandler.addLabel(labelName, rateLimitGauge.getRuleName(), labels);
                    continue block14;
                }
            }
        }
        return labels;
    }

    public static Map<String, String> convertCircuitBreakToLabels(CircuitBreakGauge gauge, String callerIp) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER;
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    CommonHandler.addLabel(labelName, gauge.getNamespace(), labels);
                    continue block24;
                }
                case "callee_service": {
                    CommonHandler.addLabel(labelName, gauge.getService(), labels);
                    continue block24;
                }
                case "callee_method": {
                    CommonHandler.addLabel(labelName, gauge.getMethod(), labels);
                    continue block24;
                }
                case "callee_subset": {
                    CommonHandler.addLabel(labelName, gauge.getSubset(), labels);
                    continue block24;
                }
                case "callee_instance": {
                    CommonHandler.addLabel(labelName, CommonHandler.buildAddress(gauge.getHost(), gauge.getPort()), labels);
                    continue block24;
                }
                case "caller_namespace": {
                    String namespace = null == gauge.getCallerService() ? null : gauge.getCallerService().getNamespace();
                    CommonHandler.addLabel(labelName, namespace, labels);
                    continue block24;
                }
                case "caller_service": {
                    String serviceName = null == gauge.getCallerService() ? null : gauge.getCallerService().getService();
                    CommonHandler.addLabel(labelName, serviceName, labels);
                    continue block24;
                }
                case "caller_ip": {
                    CommonHandler.addLabel(labelName, callerIp, labels);
                    continue block24;
                }
                case "rule_name": {
                    CommonHandler.addLabel(labelName, gauge.getRuleName(), labels);
                    continue block24;
                }
                case "level": {
                    CommonHandler.addLabel(labelName, gauge.getLevel(), labels);
                    continue block24;
                }
            }
        }
        return labels;
    }

    public static void addLabel(String key, String value, Map<String, String> target) {
        if (null == key) {
            return;
        }
        if (null == value) {
            value = "__NULL__";
        }
        target.put(key, value);
    }

    public static String buildAddress(String host, int port) {
        if (null == host) {
            host = "";
        }
        return host + ":" + port;
    }
}

