/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.tencent.polaris.api.plugin.stat.CircuitBreakGauge;
import com.tencent.polaris.api.plugin.stat.RateLimitGauge;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.plugins.stat.common.model.AbstractSignatureStatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategy;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategyCollections;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollectorContainer;
import com.tencent.polaris.plugins.stat.common.model.StatInfoHandler;
import com.tencent.polaris.plugins.stat.common.model.StatInfoRevisionCollector;
import com.tencent.polaris.plugins.stat.common.model.StatMetric;
import com.tencent.polaris.plugins.stat.common.model.StatRevisionMetric;
import com.tencent.polaris.plugins.stat.common.model.SystemMetricModel;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusPushHandlerConfig;
import com.tencent.polaris.plugins.stat.prometheus.handler.ServiceDiscoveryProvider;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPushHandler
implements StatInfoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushHandler.class);
    public static final int PUSH_DEFAULT_INTERVAL_MILLI = 30000;
    public static final String PUSH_DEFAULT_JOB_NAME = "polaris-client";
    public static final String PUSH_GROUP_KEY = "instance";
    public static final int REVISION_MAX_SCOPE = 2;
    private final AtomicBoolean firstHandle = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledPushTask;
    private StatInfoCollectorContainer container;
    private final String callerIp;
    private final String jobName;
    private final String instanceName;
    private final long pushIntervalMilli;
    private final CollectorRegistry promRegistry;
    private final Map<String, Gauge> sampleMapping;
    private final ServiceDiscoveryProvider addressProvider;
    private String pushAddress;
    private PushGateway pushGateway;

    public PrometheusPushHandler(String callerIp, PrometheusPushHandlerConfig config, ServiceDiscoveryProvider provider, String jobName, String instanceName) {
        this(callerIp, config.getPushInterval(), provider, jobName, instanceName);
    }

    private PrometheusPushHandler(String callerIp, Long pushIntervalS, ServiceDiscoveryProvider provider, String jobName, String instanceName) {
        this.callerIp = callerIp;
        this.container = new StatInfoCollectorContainer();
        this.sampleMapping = new HashMap<String, Gauge>();
        this.promRegistry = new CollectorRegistry(true);
        this.addressProvider = provider;
        this.jobName = jobName;
        this.instanceName = instanceName;
        this.pushIntervalMilli = null != pushIntervalS ? pushIntervalS : 30000L;
        this.scheduledPushTask = Executors.newSingleThreadScheduledExecutor();
        this.initSampleMapping(MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
    }

    private void initSampleMapping(MetricValueAggregationStrategy<?>[] strategies, String[] order) {
        for (MetricValueAggregationStrategy<?> strategy : strategies) {
            Gauge strategyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)new Gauge.Builder().name(strategy.getStrategyName())).help(strategy.getStrategyDescription())).labelNames(order)).create().register(this.promRegistry);
            this.sampleMapping.put(strategy.getStrategyName(), strategyGauge);
        }
    }

    public void handle(StatInfo statInfo) {
        if (this.firstHandle.compareAndSet(false, true)) {
            this.startSchedulePushTask();
        }
        if (null == statInfo) {
            return;
        }
        if (null != statInfo.getRouterGauge()) {
            this.handleRouterGauge(statInfo.getRouterGauge());
        }
        if (null != statInfo.getCircuitBreakGauge()) {
            this.handleCircuitBreakGauge(statInfo.getCircuitBreakGauge());
        }
        if (null != statInfo.getRateLimitGauge()) {
            this.handleRateLimitGauge(statInfo.getRateLimitGauge());
        }
    }

    public void handleRouterGauge(InstanceGauge instanceGauge) {
        if (null != this.container && null != this.container.getInsCollector()) {
            this.container.getInsCollector().collectStatInfo((Object)instanceGauge, this.convertInsGaugeToLabels(instanceGauge), MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY);
        }
    }

    public void handleRateLimitGauge(RateLimitGauge rateLimitGauge) {
        if (null != this.container && null != this.container.getRateLimitCollector()) {
            this.container.getRateLimitCollector().collectStatInfo((Object)rateLimitGauge, this.convertRateLimitGaugeToLabels(rateLimitGauge), MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY);
        }
    }

    public void handleCircuitBreakGauge(CircuitBreakGauge circuitBreakGauge) {
        if (null != this.container && null != this.container.getCircuitBreakerCollector()) {
            this.container.getCircuitBreakerCollector().collectStatInfo((Object)circuitBreakGauge, this.convertCircuitBreakToLabels(circuitBreakGauge), MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY);
        }
    }

    public void stopHandle() {
        if (this.container != null) {
            this.container = null;
        }
        if (this.scheduledPushTask != null) {
            this.scheduledPushTask.shutdown();
            this.scheduledPushTask = null;
        }
    }

    private void startSchedulePushTask() {
        if (null != this.container && null != this.scheduledPushTask && null != this.sampleMapping) {
            this.scheduledPushTask.scheduleWithFixedDelay(this::doPush, this.pushIntervalMilli, this.pushIntervalMilli, TimeUnit.MILLISECONDS);
            LOG.info("start schedule push task, task interval {}", (Object)this.pushIntervalMilli);
        }
    }

    private void doPush() {
        try {
            this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getInsCollector(), this.container.getInsCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
            this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getRateLimitCollector(), this.container.getRateLimitCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
            this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getCircuitBreakerCollector(), 0L, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
            try {
                if (null == this.pushAddress && null != this.addressProvider) {
                    this.setPushAddress(this.addressProvider.getAddress());
                }
                if (null == this.pushAddress) {
                    return;
                }
                if (this.getPushGateway() == null) {
                    LOG.info("init push-gateway {} ", (Object)this.pushAddress);
                    this.setPushGateway(new PushGateway(this.pushAddress));
                }
                this.pushGateway.pushAdd(this.promRegistry, this.jobName, Collections.singletonMap(PUSH_GROUP_KEY, this.instanceName));
                LOG.info("push result to push-gateway {} success", (Object)this.pushAddress);
            }
            catch (IOException exception) {
                LOG.error("push result to push-gateway {} encountered exception, exception:{}", (Object)this.pushAddress, (Object)exception.getMessage());
                this.setPushGateway(null);
                this.setPushAddress(null);
                return;
            }
            for (StatInfoCollector s : this.container.getCollectors()) {
                if (!(s instanceof StatInfoRevisionCollector)) continue;
                long currentRevision = ((StatInfoRevisionCollector)s).incRevision();
                LOG.debug("RevisionCollector inc current revision to {}", (Object)currentRevision);
            }
        }
        catch (Exception e) {
            LOG.error("push result to push-gateway {} encountered exception, exception:{}", (Object)this.pushAddress, (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void putDataFromContainerInOrder(AbstractSignatureStatInfoCollector<?, ? extends StatMetric> collector, long currentRevision, String[] order) {
        Collection values = collector.getCollectedValues();
        for (StatMetric s : values) {
            Gauge.Child child;
            Gauge gauge = this.sampleMapping.get(s.getMetricName());
            if (null == gauge) continue;
            if (s instanceof StatRevisionMetric) {
                StatRevisionMetric rs = (StatRevisionMetric)s;
                if (rs.getRevision() < currentRevision - 2L) {
                    gauge.remove(PrometheusPushHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    collector.getMetricContainer().remove(s.getSignature());
                    continue;
                }
                if (rs.getRevision() < currentRevision) {
                    gauge.remove(PrometheusPushHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    Gauge.Child child2 = (Gauge.Child)gauge.labels(PrometheusPushHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    if (null == child2) continue;
                    child2.set(0.0);
                    continue;
                }
            }
            if (null == (child = (Gauge.Child)gauge.labels(PrometheusPushHandler.getOrderedMetricLabelValues(s.getLabels(), order)))) continue;
            child.set(s.getValue());
        }
    }

    public static String[] getOrderedMetricLabelValues(Map<String, String> labels, String[] orderedKey) {
        String[] orderValue = new String[orderedKey.length];
        for (int i = 0; i < orderedKey.length; ++i) {
            orderValue[i] = labels.getOrDefault(orderedKey[i], "__NULL__");
        }
        return orderValue;
    }

    protected Map<String, String> convertInsGaugeToLabels(InstanceGauge insGauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, insGauge.getNamespace(), labels);
                    continue block24;
                }
                case "callee_service": {
                    this.addLabel(labelName, insGauge.getService(), labels);
                    continue block24;
                }
                case "callee_method": {
                    this.addLabel(labelName, insGauge.getMethod(), labels);
                    continue block24;
                }
                case "callee_subset": {
                    this.addLabel(labelName, insGauge.getSubset(), labels);
                    continue block24;
                }
                case "callee_instance": {
                    this.addLabel(labelName, PrometheusPushHandler.buildAddress(insGauge.getHost(), insGauge.getPort()), labels);
                    continue block24;
                }
                case "callee_result_code": {
                    String retCodeStr = null == insGauge.getRetCode() ? null : insGauge.getRetCode().toString();
                    this.addLabel(labelName, retCodeStr, labels);
                    continue block24;
                }
                case "caller_labels": {
                    this.addLabel(labelName, insGauge.getLabels(), labels);
                    continue block24;
                }
                case "caller_namespace": {
                    String namespace = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getNamespace();
                    this.addLabel(labelName, namespace, labels);
                    continue block24;
                }
                case "caller_service": {
                    String serviceName = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getService();
                    this.addLabel(labelName, serviceName, labels);
                    continue block24;
                }
                case "caller_ip": {
                    this.addLabel(labelName, this.callerIp, labels);
                    continue block24;
                }
            }
        }
        return labels;
    }

    protected Map<String, String> convertRateLimitGaugeToLabels(RateLimitGauge rateLimitGauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, rateLimitGauge.getNamespace(), labels);
                    continue block12;
                }
                case "callee_service": {
                    this.addLabel(labelName, rateLimitGauge.getService(), labels);
                    continue block12;
                }
                case "callee_method": {
                    this.addLabel(labelName, rateLimitGauge.getMethod(), labels);
                    continue block12;
                }
                case "caller_labels": {
                    this.addLabel(labelName, rateLimitGauge.getLabels(), labels);
                    continue block12;
                }
            }
        }
        return labels;
    }

    protected Map<String, String> convertCircuitBreakToLabels(CircuitBreakGauge gauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER;
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, gauge.getNamespace(), labels);
                    continue block20;
                }
                case "callee_service": {
                    this.addLabel(labelName, gauge.getService(), labels);
                    continue block20;
                }
                case "callee_method": {
                    this.addLabel(labelName, gauge.getMethod(), labels);
                    continue block20;
                }
                case "callee_subset": {
                    this.addLabel(labelName, gauge.getSubset(), labels);
                    continue block20;
                }
                case "callee_instance": {
                    this.addLabel(labelName, PrometheusPushHandler.buildAddress(gauge.getHost(), gauge.getPort()), labels);
                    continue block20;
                }
                case "caller_namespace": {
                    String namespace = null == gauge.getCallerService() ? null : gauge.getCallerService().getNamespace();
                    this.addLabel(labelName, namespace, labels);
                    continue block20;
                }
                case "caller_service": {
                    String serviceName = null == gauge.getCallerService() ? null : gauge.getCallerService().getService();
                    this.addLabel(labelName, serviceName, labels);
                    continue block20;
                }
                case "caller_ip": {
                    this.addLabel(labelName, this.callerIp, labels);
                    continue block20;
                }
            }
        }
        return labels;
    }

    private void addLabel(String key, String value, Map<String, String> target) {
        if (null == key) {
            return;
        }
        if (null == value) {
            value = "__NULL__";
        }
        target.put(key, value);
    }

    private static String buildAddress(String host, int port) {
        if (null == host) {
            host = "";
        }
        return host + ":" + port;
    }

    protected void setPushAddress(String address) {
        this.pushAddress = address;
    }

    protected void setPushGateway(PushGateway pushGateway) {
        this.pushGateway = pushGateway;
    }

    protected PushGateway getPushGateway() {
        return this.pushGateway;
    }

    protected CollectorRegistry getPromRegistry() {
        return this.promRegistry;
    }
}

