/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusPushHandlerConfig;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ServiceDiscoveryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDiscoveryProvider.class);
    private final Extensions extensions;
    private final ServiceKey pushService;
    private final List<String> coreRouters = new ArrayList<String>();
    private final String pushAddress;

    public ServiceDiscoveryProvider(Extensions extensions, PrometheusPushHandlerConfig pushHandlerConfig) {
        this.extensions = extensions;
        if (!StringUtils.isBlank((String)pushHandlerConfig.getPushgatewayService()) && !StringUtils.isBlank((String)pushHandlerConfig.getPushgatewayNamespace())) {
            this.pushService = new ServiceKey(pushHandlerConfig.getPushgatewayNamespace(), pushHandlerConfig.getPushgatewayService());
            this.pushAddress = null;
        } else {
            this.pushService = null;
            this.pushAddress = pushHandlerConfig.getPushgatewayAddress();
        }
        this.coreRouters.add("metadataRouter");
    }

    public String getAddress() {
        if (null == this.pushService && StringUtils.isBlank((String)this.pushAddress)) {
            return null;
        }
        if (!StringUtils.isBlank((String)this.pushAddress)) {
            return this.pushAddress;
        }
        Instance instance = null;
        try {
            instance = BaseFlow.commonGetOneInstance((Extensions)this.extensions, (ServiceKey)this.pushService, this.coreRouters, (String)"weightedRandom", (String)this.extensions.getConfiguration().getGlobal().getServerConnector().getProtocol(), (String)this.extensions.getValueContext().getClientId());
        }
        catch (Exception e) {
            LOG.error("fail to discover service " + this.pushService, (Throwable)e);
        }
        if (null != instance) {
            return instance.getHost() + ":" + instance.getPort();
        }
        return null;
    }
}

