/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;

public class HttpMetricHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMetricHandler.class);
    private final CollectorRegistry collectorRegistry;
    private final LocalByteArray response = new LocalByteArray();

    public HttpMetricHandler() {
        this.collectorRegistry = CollectorRegistry.defaultRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String query = exchange.getRequestURI().getRawQuery();
        String contextPath = exchange.getHttpContext().getPath();
        ByteArrayOutputStream response = (ByteArrayOutputStream)this.response.get();
        response.reset();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response, StandardCharsets.UTF_8);
        if ("/-/healthy".equals(contextPath)) {
            osw.write("Exporter is Healthy.");
        } else {
            String contentType = TextFormat.chooseContentType((String)exchange.getRequestHeaders().getFirst("Accept"));
            exchange.getResponseHeaders().set("Content-Type", contentType);
            TextFormat.writeFormat((String)contentType, (Writer)osw, (Enumeration)this.collectorRegistry.filteredMetricFamilySamples(this.parseQuery(query)));
        }
        osw.close();
        if (this.shouldUseCompression(exchange)) {
            exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            exchange.sendResponseHeaders(200, 0L);
            try (GZIPOutputStream os = new GZIPOutputStream(exchange.getResponseBody());){
                response.writeTo(os);
            }
        } else {
            exchange.getResponseHeaders().set("Content-Length", String.valueOf(response.size()));
            exchange.sendResponseHeaders(200, response.size());
            response.writeTo(exchange.getResponseBody());
        }
        LOG.info("Metrics is pulled by prometheus");
        exchange.close();
    }

    private boolean shouldUseCompression(HttpExchange exchange) {
        Object encodingHeaders = exchange.getRequestHeaders().get("Accept-Encoding");
        if (encodingHeaders != null) {
            Iterator iterator = encodingHeaders.iterator();
            while (iterator.hasNext()) {
                String[] encodings;
                String encodingHeader = (String)iterator.next();
                for (String encoding : encodings = encodingHeader.split(",")) {
                    if (!"gzip".equalsIgnoreCase(encoding.trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<String> parseQuery(String query) throws IOException {
        HashSet<String> names = new HashSet<String>();
        if (StringUtils.isNotBlank((String)query)) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                String decodeKey = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                if (idx == -1 || !"name[]".equals(decodeKey)) continue;
                names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return names;
    }

    private static class LocalByteArray
    extends ThreadLocal<ByteArrayOutputStream> {
        private LocalByteArray() {
        }

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(0x100000);
        }
    }
}

