/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.sun.net.httpserver.HttpServer;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.prometheus.handler.HttpMetricHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;

public class PrometheusHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusHttpServer.class);
    private static final String DEFAULT_PATH = "/metrics";
    private static final int MIN_RANDOM_PORT = 20000;
    private static final int MAX_RANDOM_PORT = 65535;
    private final HttpServer httpServer;
    private final ThreadFactory threadFactory;
    private final ExecutorService executor;
    private final String host;
    private int port;
    private String path;

    public PrometheusHttpServer(String host, int port) {
        this(host, port, DEFAULT_PATH);
    }

    public PrometheusHttpServer(String host, int port, String path) {
        try {
            this.host = host;
            this.path = path;
            this.setServerPort(port);
            this.threadFactory = new DaemonNamedThreadFactory("prometheus-http");
            this.httpServer = HttpServer.create(new InetSocketAddress(this.host, this.port), 3);
            HttpMetricHandler metricHandler = new HttpMetricHandler();
            this.httpServer.createContext("/", metricHandler);
            this.httpServer.createContext(path, metricHandler);
            this.httpServer.createContext("/-/healthy", metricHandler);
            this.executor = Executors.newFixedThreadPool(3, this.threadFactory);
            this.httpServer.setExecutor(this.executor);
            this.startServer();
        }
        catch (IOException e) {
            LOGGER.error("Create prometheus http server exception. host:{}, port:{}, path:{}", new Object[]{host, port, path, e});
            throw new UncheckedIOException("Create prometheus http server failed!", e);
        }
    }

    private void setServerPort(int port) {
        if (port == 0) {
            int randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
            while (!this.isPortAvailable(randomPort)) {
                randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
            }
            this.port = randomPort;
            return;
        }
        this.port = port;
    }

    private boolean isPortAvailable(int port) {
        try {
            this.bindPort("0.0.0.0", port);
            this.bindPort(InetAddress.getLocalHost().getHostAddress(), port);
            this.bindPort(InetAddress.getLoopbackAddress().getHostAddress(), port);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void bindPort(String host, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.bind(new InetSocketAddress(host, port));
        }
    }

    private void startServer() {
        if (Thread.currentThread().isDaemon()) {
            this.httpServer.start();
            return;
        }
        Thread httpServerThread = this.threadFactory.newThread(() -> this.httpServer.start());
        httpServerThread.start();
        try {
            httpServerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopServer() {
        this.httpServer.stop(0);
        this.executor.shutdownNow();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    private static final class DaemonNamedThreadFactory
    extends NamedThreadFactory {
        public DaemonNamedThreadFactory(String component) {
            super(component);
        }

        public Thread newThread(Runnable r) {
            Thread thread = super.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

