/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.plugin;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.common.model.StatInfoHandler;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHandler;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHandlerConfig;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHttpServer;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class PrometheusReporter
implements StatReporter,
PluginConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusReporter.class);
    private StatInfoHandler statInfoHandler;
    private PrometheusHttpServer httpServer;
    private ScheduledExecutorService reportClientExecutor;

    public void init(InitContext initContext) throws PolarisException {
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        if (extensions.getConfiguration().getGlobal().getStatReporter().isEnable()) {
            PrometheusHandlerConfig config = (PrometheusHandlerConfig)extensions.getConfiguration().getGlobal().getStatReporter().getPluginConfig(this.getName(), PrometheusHandlerConfig.class);
            if (config.getPort() == -1) {
                return;
            }
            String host = StringUtils.isBlank((String)config.getHost()) ? extensions.getValueContext().getHost() : config.getHost();
            this.statInfoHandler = new PrometheusHandler(host);
            this.httpServer = new PrometheusHttpServer(host, config.getPort());
            this.reportClientExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(this.getName()));
            this.reportClient(extensions);
        }
    }

    public void reportStat(StatInfo statInfo) {
        if (null != this.statInfoHandler && null != statInfo) {
            this.statInfoHandler.handle(statInfo);
        }
    }

    public ReporterMetaInfo metaInfo() {
        return ReporterMetaInfo.builder().protocol("http").path(this.httpServer.getPath()).host(this.httpServer.getHost()).port(Integer.valueOf(this.httpServer.getPort())).target(this.getName()).build();
    }

    public String getName() {
        return "prometheus";
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return PrometheusHandlerConfig.class;
    }

    public PluginType getType() {
        return PluginTypes.STAT_REPORTER.getBaseType();
    }

    public void destroy() {
        if (null != this.statInfoHandler) {
            this.statInfoHandler.stopHandle();
            this.statInfoHandler = null;
        }
        if (this.reportClientExecutor != null) {
            this.reportClientExecutor.shutdown();
            this.reportClientExecutor = null;
        }
        if (this.httpServer != null) {
            this.httpServer.stopServer();
            this.httpServer = null;
        }
    }

    private void reportClient(Extensions extensions) {
        if (this.reportClientExecutor != null) {
            this.reportClientExecutor.scheduleAtFixedRate(() -> {
                ServerConnector serverConnector = extensions.getServerConnector();
                ReportClientRequest reportClientRequest = new ReportClientRequest();
                reportClientRequest.setClientHost(extensions.getValueContext().getHost());
                reportClientRequest.setVersion("1.9.1");
                reportClientRequest.setReporterMetaInfos(Collections.singletonList(this.metaInfo()));
                try {
                    ReportClientResponse reportClientResponse = serverConnector.reportClient(reportClientRequest);
                    LOGGER.debug("Report prometheus http server metadata success, response:{}", (Object)reportClientResponse);
                }
                catch (PolarisException e) {
                    LOGGER.error("Report prometheus http server info exception.", (Throwable)e);
                }
            }, 0L, 60L, TimeUnit.SECONDS);
        }
    }
}

