/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.pushgateway.plugin;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.plugins.stat.common.model.StatInfoHandler;
import com.tencent.polaris.plugins.stat.pushgateway.handler.PrometheusPushHandler;
import com.tencent.polaris.plugins.stat.pushgateway.handler.PrometheusPushHandlerConfig;
import com.tencent.polaris.plugins.stat.pushgateway.handler.ServiceDiscoveryProvider;

public class PrometheusPushReporter
implements StatReporter,
PluginConfigProvider {
    public static final String PUSH_DEFAULT_JOB_NAME = "polaris-client";
    private static final String PROMETHEUS_PUSH_GATEWAY_PLUGIN_NAME = "prometheus-pushgateway";
    private StatInfoHandler statInfoHandler;

    public void init(InitContext initContext) throws PolarisException {
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        if (extensions.getConfiguration().getGlobal().getStatReporter().isEnable()) {
            PrometheusPushHandlerConfig config = (PrometheusPushHandlerConfig)extensions.getConfiguration().getGlobal().getStatReporter().getPluginConfig(this.getName(), PrometheusPushHandlerConfig.class);
            ServiceDiscoveryProvider provider = new ServiceDiscoveryProvider(extensions, config);
            String instanceId = extensions.getValueContext().getClientId();
            String host = extensions.getValueContext().getHost();
            this.statInfoHandler = new PrometheusPushHandler(host, config, provider, PUSH_DEFAULT_JOB_NAME, instanceId);
        }
    }

    public void reportStat(StatInfo statInfo) {
        if (null != this.statInfoHandler && null != statInfo) {
            this.statInfoHandler.handle(statInfo);
        }
    }

    public ReporterMetaInfo metaInfo() {
        return null;
    }

    public String getName() {
        return PROMETHEUS_PUSH_GATEWAY_PLUGIN_NAME;
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return PrometheusPushHandlerConfig.class;
    }

    public PluginType getType() {
        return PluginTypes.STAT_REPORTER.getBaseType();
    }

    public void destroy() {
        if (null != this.statInfoHandler) {
            this.statInfoHandler.stopHandle();
            this.statInfoHandler = null;
        }
    }
}

