/**
 * Tencent is pleased to support the open source community by making Tars available.
 *
 * Copyright (C) 2016 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
// **********************************************************************
// This file was generated by a TARS parser!
// TARS version 1.0.1.
// **********************************************************************

package com.qq.tars.support.stat.prx;

import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.tars.annotation.TarsCallback;
import com.qq.tars.protocol.tars.annotation.TarsContext;

import java.util.concurrent.CompletableFuture;

/**
 * Interface to the report service
 **/
@Servant
public interface StatFPrx {
    /**
     * Report calling information between modules Mic = module interval call
     * @param statmsg,     Report information
     * @param bFromServer, Report source  bFromClient: true (Reporting initiated by the client) false (Reporting initiated by the server)
     * @return int,                Return 0 means success
     */
    public int reportMicMsg(java.util.Map<StatMicMsgHead, StatMicMsgBody> msg, boolean bFromClient);

    /**
     * Report calling information between modules Mic = module interval call
     * @param statmsg,     Report information
     * @param bFromServer, Report source  bFromClient: true (Reporting initiated by the client) false (Reporting initiated by the server)
     * @return int,                Return 0 means success
     */
    public int reportMicMsg(java.util.Map<StatMicMsgHead, StatMicMsgBody> msg, boolean bFromClient, @TarsContext java.util.Map<String, String> ctx);

    /**
     * Report calling information between modules Mic = module interval call
     * @param statmsg,     Report information
     * @param bFromServer, Report source  bFromClient: true (Reporting initiated by the client) false (Reporting initiated by the server)
     * @return int,                Return 0 means success
     */
    public void async_reportMicMsg(@TarsCallback StatFPrxCallback callback, java.util.Map<StatMicMsgHead, StatMicMsgBody> msg, boolean bFromClient);

    CompletableFuture<Integer> promise_reportMicMsg(java.util.Map<StatMicMsgHead, StatMicMsgBody> msg, boolean bFromClient);

    /**
     * Report calling information between modules Mic = module interval call
     * @param statmsg,     Report information
     * @param bFromServer, Report source  bFromClient: true (Reporting initiated by the client) false (Reporting initiated by the server)
     * @return int,                Return 0 means success
     */
    public void async_reportMicMsg(@TarsCallback StatFPrxCallback callback, java.util.Map<StatMicMsgHead, StatMicMsgBody> msg, boolean bFromClient, @TarsContext java.util.Map<String, String> ctx);

    /**
     * 上报模块间调用采样信息 Mic = module interval call
     * @param msg, Report information
     * @return int,                Return 0 means success
     */
    public int reportSampleMsg(java.util.List<StatSampleMsg> msg);

    /**
     * 上报模块间调用采样信息 Mic = module interval call
     * @param msg, Report information
     * @return int,                Return 0 means success
     */
    public int reportSampleMsg(java.util.List<StatSampleMsg> msg, @TarsContext java.util.Map<String, String> ctx);

    /**
     * 上报模块间调用采样信息 Mic = module interval call
     * @param msg, Report information
     * @return int,                Return 0 means success
     */
    public void async_reportSampleMsg(@TarsCallback StatFPrxCallback callback, java.util.List<StatSampleMsg> msg);

    /**
     * 上报模块间调用采样信息 Mic = module interval call
     * @param msg, Report information
     * @return int,                Return 0 means success
     */
    public void async_reportSampleMsg(@TarsCallback StatFPrxCallback callback, java.util.List<StatSampleMsg> msg, @TarsContext java.util.Map<String, String> ctx);
}
