/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.client.ticket;

import com.qq.tars.net.client.ticket.Ticket;
import com.qq.tars.net.client.ticket.TicketManager;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeoutManager {
    protected static ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(2);

    public static Future<?> watch(Runnable task, long timeout) {
        return scheduled.schedule(task, timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean cancelTimeoutTask(Ticket<?> ticket) {
        return ticket.getTimeoutFuture().cancel(false);
    }

    public static void shutdown() {
        scheduled.shutdownNow();
    }

    public static class TimeoutTask
    implements Runnable {
        Ticket<?> ticket;

        public TimeoutTask(Ticket<?> ticket) {
            this.ticket = ticket;
        }

        @Override
        public void run() {
            try {
                TicketManager.removeTicket(this.ticket.getTicketNumber());
                this.ticket.expired();
            }
            catch (Exception e) {
                System.out.println("timeout exception:" + e);
            }
        }
    }
}

