/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring.bean;

import com.qq.tars.server.core.Server;
import com.qq.tars.spring.annotation.RemoteConfigSource;
import com.qq.tars.support.config.ConfigHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;

public class ConfigSourceListener
implements ApplicationListener<ApplicationStartingEvent> {
    private static final AtomicBoolean INIT = new AtomicBoolean();

    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (!INIT.compareAndSet(false, true)) {
            return;
        }
        RemoteConfigSource sources = event.getSpringApplication().getMainApplicationClass().getAnnotation(RemoteConfigSource.class);
        if (sources != null) {
            File[] files;
            String configPath = Server.getInstance().getServerConfig().getBasePath() + "/conf/";
            Path path = Paths.get(configPath, new String[0]);
            File configDirectory = path.toFile();
            if (configDirectory.isDirectory() && (files = configDirectory.listFiles()) != null) {
                File[] fileArray = files;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file = fileArray[i];
                    if (file.delete()) continue;
                    throw new RuntimeException("[TARS] delete legacy config failed: " + file.getName());
                }
            }
            for (String name : sources.value()) {
                if (!ConfigHelper.getInstance().loadConfig(name)) {
                    throw new RuntimeException("[TARS] load config failed: " + name);
                }
                System.out.println("[TARS] load config: " + name);
            }
        }
    }
}

