/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.util.Pair;
import android.view.Surface;
import org.libpag.a;

public class PAGSurface {
    private Surface a = null;
    private boolean b = false;
    private int c = 0;
    long nativeSurface;

    public static PAGSurface MakeOffscreen(int n, int n2) {
        long l2 = PAGSurface.SetupOffscreen(n, n2);
        if (l2 == 0L) {
            return null;
        }
        return new PAGSurface(l2);
    }

    public static PAGSurface FromSurfaceTexture(SurfaceTexture surfaceTexture) {
        return PAGSurface.FromSurfaceTexture(surfaceTexture, EGL14.EGL_NO_CONTEXT);
    }

    public static PAGSurface FromSurfaceTexture(SurfaceTexture object, EGLContext eGLContext) {
        if (object == null) {
            return null;
        }
        if ((object = PAGSurface.FromSurface(new Surface(object), eGLContext)) != null) {
            object.b = true;
        }
        return object;
    }

    public static PAGSurface FromSurface(Surface surface) {
        return PAGSurface.FromSurface(surface, EGL14.EGL_NO_CONTEXT);
    }

    public static PAGSurface FromSurface(Surface surface, EGLContext eGLContext) {
        if (surface == null) {
            return null;
        }
        long l2 = 0L;
        if (eGLContext != null && eGLContext != EGL14.EGL_NO_CONTEXT) {
            l2 = Build.VERSION.SDK_INT >= 21 ? eGLContext.getNativeHandle() : (long)eGLContext.getHandle();
        }
        if ((l2 = PAGSurface.SetupFromSurfaceWithGLContext(surface, l2)) == 0L) {
            return null;
        }
        new PAGSurface(l2).a = surface;
        return new PAGSurface(l2);
    }

    public static PAGSurface FromTexture(int n, int n2, int n3) {
        return PAGSurface.FromTexture(n, n2, n3, false);
    }

    public static PAGSurface FromTexture(int n, int n2, int n3, boolean bl) {
        long l2 = PAGSurface.SetupFromTexture(n, n2, n3, bl, false);
        if (l2 == 0L) {
            return null;
        }
        new PAGSurface(l2).c = n;
        return new PAGSurface(l2);
    }

    public static PAGSurface FromTextureForAsyncThread(int n, int n2, int n3) {
        return PAGSurface.FromTextureForAsyncThread(n, n2, n3, false);
    }

    public static PAGSurface FromTextureForAsyncThread(int n, int n2, int n3, boolean bl) {
        long l2 = PAGSurface.SetupFromTexture(n, n2, n3, bl, true);
        if (l2 == 0L) {
            return null;
        }
        new PAGSurface(l2).c = n;
        return new PAGSurface(l2);
    }

    private static native long SetupOffscreen(int var0, int var1);

    private static native long SetupFromSurfaceWithGLContext(Surface var0, long var1);

    public static native long SetupFromTexture(int var0, int var1, int var2, boolean var3, boolean var4);

    private PAGSurface(long l2) {
        this.nativeSurface = l2;
    }

    private native void nativeRelease();

    private static native void nativeInit();

    private native void nativeFinalize();

    static {
        org.extra.tools.a.b("pag");
        PAGSurface.nativeInit();
    }

    public native int width();

    public native int height();

    public native void updateSize();

    public native boolean clearAll();

    public native void freeCache();

    public Bitmap makeSnapshot() {
        Pair pair = org.libpag.a.a(this.width(), this.height(), true);
        if (pair.first == null) {
            return null;
        }
        Object object = pair.second;
        if (object != null && Build.VERSION.SDK_INT >= 26) {
            ((HardwareBuffer)object).close();
        }
        return this.copyPixelsTo((Bitmap)pair.first) ? (Bitmap)pair.first : null;
    }

    public native boolean copyPixelsTo(Bitmap var1);

    public void release() {
        Surface surface;
        PAGSurface pAGSurface = this;
        pAGSurface.freeCache();
        if (pAGSurface.b && (surface = this.a) != null) {
            surface.release();
        }
        this.nativeRelease();
    }

    protected void finalize() {
        this.nativeFinalize();
    }
}

