/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.smtt.export.external.DexClassLoaderProvider;
import com.tencent.smtt.utils.l;
import dalvik.system.DexClassLoader;
import dalvik.system.VMStack;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class DexLoader {
    private static final String JAVACORE_PACKAGE_PREFIX = "org.chromium";
    private static final String TENCENT_PACKAGE_PREFIX = "com.tencent";
    private static final String TAF_PACKAGE_PREFIX = "com.taf";
    private static final String TAG = "DexLoader";
    private static final String TBS_FUSION_DEX = "tbs_jars_fusion_dex";
    private static final String TBS_WEBVIEW_DEX = "webview_dex";
    private static boolean mUseTbsCorePrivateClassLoader = false;
    private static boolean mUseSpeedyClassLoader = false;
    static boolean mCanUseDexLoaderProviderService = true;
    private static boolean mMttClassUseCorePrivate = false;
    private DexClassLoader mClassLoader;

    public static void initTbsSettings(Map<String, Object> map) {
        Log.d((String)TAG, (String)("initTbsSettings - " + map));
        if (map != null) {
            try {
                Object object = map.get("use_private_classloader");
                if (object instanceof Boolean) {
                    mUseTbsCorePrivateClassLoader = (Boolean)object;
                }
                if ((object = map.get("use_speedy_classloader")) instanceof Boolean) {
                    mUseSpeedyClassLoader = (Boolean)object;
                }
                if ((object = map.get("use_dexloader_service")) instanceof Boolean) {
                    mCanUseDexLoaderProviderService = (Boolean)object;
                }
                if ((object = map.get("use_mtt_classes")) instanceof Boolean) {
                    mMttClassUseCorePrivate = (Boolean)object;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private boolean shouldUseTbsCorePrivateClassLoader(String string) {
        if (!mUseTbsCorePrivateClassLoader) {
            return false;
        }
        return string.contains(TBS_FUSION_DEX) || string.contains(TBS_WEBVIEW_DEX);
    }

    public DexLoader(String string, Context context, String[] stringArray, String string2) {
        this(string, context, stringArray, string2, null);
    }

    public DexLoader(String string, Context context, String[] stringArray, String string2, Map<String, Object> map) {
        DexLoader.initTbsSettings(map);
        ClassLoader classLoader = VMStack.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = context.getClassLoader();
        }
        Log.d((String)"dexloader", (String)("Set base classLoader for DexClassLoader: " + classLoader));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.mClassLoader = this.createDexClassLoader(stringArray[i2], string2, string, classLoader, context);
            classLoader = this.mClassLoader;
        }
    }

    public DexLoader(Context context, String[] stringArray, String string) {
        this(null, context, stringArray, string);
    }

    public DexLoader(Context context, String[] stringArray, String string, String string2) {
        ClassLoader classLoader = context.getClassLoader();
        String string3 = context.getApplicationInfo().nativeLibraryDir;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string3 + File.pathSeparator + string2;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.mClassLoader = this.createDexClassLoader(stringArray[i2], string, string3, classLoader, context);
            classLoader = this.mClassLoader;
        }
    }

    public DexLoader(Context context, String[] stringArray, String string, DexLoader dexLoader) {
        DexClassLoader dexClassLoader = dexLoader.getClassLoader();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            dexClassLoader = this.mClassLoader = this.createDexClassLoader(stringArray[i2], string, context.getApplicationInfo().nativeLibraryDir, (ClassLoader)dexClassLoader, context);
        }
    }

    public DexLoader(Context context, String string, String string2) {
        this(context, new String[]{string}, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexClassLoader createDexClassLoader(String string, String string2, String string3, ClassLoader classLoader, Context context) {
        Object object;
        if (Build.VERSION.SDK_INT >= 29) {
            object = string + "_code";
            String string4 = string + "_name";
            String string5 = string + "_display";
            SharedPreferences sharedPreferences = context.getSharedPreferences("tbs_oat_status", 0);
            File file = new File(string);
            File file2 = new File(context.getDir("tbs", 0), "core_private");
            l l2 = null;
            try {
                int n2 = sharedPreferences.getInt(object, -1);
                String string6 = sharedPreferences.getString(string4, "");
                String string7 = sharedPreferences.getString(string5, "");
                String string8 = context.getPackageName();
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(string8, 0);
                int n3 = packageInfo.versionCode;
                String string9 = packageInfo.versionName;
                String string10 = Build.DISPLAY;
                Log.i((String)TAG, (String)("createDexClassLoader,old VerisonCode=" + string6 + ";newVersionCode=" + n3 + "oldVersionName" + string6 + ";newVersionName+" + string9 + "oldDisplay" + string7 + ";newDisplay=" + string10));
                if (n3 != n2 || !string9.equals(string6) || !string10.equals(string7)) {
                    Log.e((String)TAG, (String)"version updated!,clear oat file");
                    l2 = new l(file2, file.getName() + "_loading.lock");
                    l2.b();
                    n2 = sharedPreferences.getInt(object, -1);
                    string6 = sharedPreferences.getString(string4, "");
                    string7 = sharedPreferences.getString(string5, "");
                    if (n3 != n2 || !string9.equals(string6) || !string10.equals(string7)) {
                        File file3 = new File(file.getParent(), "oat");
                        String string11 = DexLoader.getFileNameNoEx(file.getName());
                        File file4 = new File(file3, file.getName() + ".prof");
                        File file5 = new File(file3, file.getName() + ".cur.prof");
                        File file6 = new File(file3, "arm");
                        File file7 = new File(file6, string11 + ".odex");
                        File file8 = new File(file6, string11 + ".vdex");
                        DexLoader.delete(file4);
                        DexLoader.delete(file5);
                        DexLoader.delete(file7);
                        DexLoader.delete(file8);
                        Log.i((String)TAG, (String)("delete file:" + file4 + file5 + file7 + file8));
                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        editor.putString(string4, string9);
                        editor.putInt(object, n3);
                        editor.putString(string5, string10);
                        editor.commit();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (l2 != null) {
                    l2.e();
                }
            }
        }
        object = null;
        Log.d((String)"dexloader", (String)("createDexClassLoader: " + string));
        if (this.shouldUseTbsCorePrivateClassLoader(string)) {
            object = new TbsCorePrivateClassLoader(string, string2, string3, classLoader);
        } else if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 25 && mUseSpeedyClassLoader) {
            Log.d((String)"dexloader", (String)"async odex...DexClassLoaderProvider.createDexClassLoader");
            try {
                object = DexClassLoaderProvider.createDexClassLoader(string, string2, string3, classLoader, context);
            }
            catch (Throwable throwable) {
                Log.e((String)"dexloader", (String)("createDexClassLoader exception: " + throwable));
                Log.d((String)"dexloader", (String)"sync odex...new DexClassLoader#2");
                object = new DexClassLoader(string, string2, string3, classLoader);
            }
        } else {
            Log.d((String)"dexloader", (String)"sync odex...new DexClassLoader");
            object = new DexClassLoader(string, string2, string3, classLoader);
        }
        Log.d((String)"dexloader", (String)("createDexClassLoader result: " + object));
        return object;
    }

    public static String getFileNameNoEx(String string) {
        int n2;
        if (string != null && string.length() > 0 && (n2 = string.lastIndexOf(46)) > -1 && n2 < string.length()) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            DexLoader.delete(file2);
        }
        file.delete();
    }

    public DexClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public Object newInstance(String string) {
        try {
            return this.mClassLoader.loadClass(string).newInstance();
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("create " + string + " instance failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object newInstance(String string, Class<?>[] classArray, Object ... objectArray) {
        try {
            return this.mClassLoader.loadClass(string).getConstructor(classArray).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            if ("com.tencent.smtt.webkit.adapter.X5WebViewAdapter".equalsIgnoreCase(string)) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'newInstance " + string + " failed"), (Throwable)throwable);
                return throwable;
            }
            Log.e((String)this.getClass().getSimpleName(), (String)("create '" + string + "' instance failed"), (Throwable)throwable);
            return null;
        }
    }

    public Class<?> loadClass(String string) {
        try {
            return this.mClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("loadClass '" + string + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object invokeStaticMethod(String string, String string2, Class<?>[] classArray, Object ... objectArray) {
        try {
            Method method = this.mClassLoader.loadClass(string).getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            if (string2 != null && string2.equalsIgnoreCase("initTesRuntimeEnvironment")) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
                return throwable;
            }
            Log.i((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object invokeMethod(Object object, String string, String string2, Class<?>[] classArray, Object ... objectArray) {
        try {
            Method method = this.mClassLoader.loadClass(string).getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke method '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object getStaticField(String string, String string2) {
        try {
            Field field = this.mClassLoader.loadClass(string).getField(string2);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' get field '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public void setStaticField(String string, String string2, Object object) {
        try {
            Field field = this.mClassLoader.loadClass(string).getField(string2);
            field.setAccessible(true);
            field.set(null, object);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' set field '" + string2 + "' failed"), (Throwable)throwable);
            return;
        }
    }

    private static class TbsCorePrivateClassLoader
    extends DexClassLoader {
        public TbsCorePrivateClassLoader(String string, String string2, String string3, ClassLoader classLoader) {
            super(string, string2, string3, classLoader);
        }

        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string != null) {
                boolean bl2 = string.startsWith(DexLoader.JAVACORE_PACKAGE_PREFIX);
                if (mMttClassUseCorePrivate) {
                    boolean bl3 = bl2 = bl2 || string.startsWith(DexLoader.TENCENT_PACKAGE_PREFIX) || string.startsWith(DexLoader.TAF_PACKAGE_PREFIX);
                }
                if (!bl2) {
                    return super.loadClass(string, bl);
                }
                Class clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    ClassLoader classLoader;
                    try {
                        Log.d((String)DexLoader.TAG, (String)("WebCoreClassLoader - loadClass(" + string + "," + bl + ")..."));
                        clazz = this.findClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz == null && (classLoader = this.getParent()) != null) {
                        clazz = classLoader.loadClass(string);
                    }
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

