/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.smtt.sdk.TbsDownloader;
import com.tencent.smtt.sdk.TbsLogReport;
import com.tencent.smtt.sdk.TbsPVConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TbsDownloadConfig {
    public static final int KEY_TODO = -1;
    public static final int ERROR_REPORTED = 0;
    public static final int ERROR_NONE = 1;
    public static final int ERROR_DOWNLOAD = 2;
    public static final int ERROR_VERIFY = 3;
    public static final int ERROR_UNZIP = 4;
    public static final int ERROR_INSTALL = 5;
    public static final int ERROR_LOAD = 6;
    public static final int CMD_ID_FILE_UPLOAD = 100;
    public static final int CMD_ID_DOWNLOAD_FILE = 101;
    public static final long DEFAULT_RETRY_INTERVAL_SEC = 86400L;
    private static TbsDownloadConfig a;
    public Map<String, Object> mSyncMap = new HashMap<String, Object>();
    public SharedPreferences mPreferences;
    private Context b;

    private TbsDownloadConfig(Context context) {
        this.mPreferences = context.getSharedPreferences("tbs_download_config", 4);
        this.b = context.getApplicationContext();
        if (this.b == null) {
            this.b = context;
        }
    }

    public static synchronized TbsDownloadConfig getInstance(Context context) {
        if (a == null) {
            a = new TbsDownloadConfig(context);
        }
        return a;
    }

    public static synchronized TbsDownloadConfig getInstance() {
        return a;
    }

    public synchronized long getDownloadMaxflow() {
        int n2 = this.mPreferences.getInt("tbs_download_maxflow", 0);
        n2 = n2 == 0 ? 20 : n2;
        return (long)(n2 * 1024) * 1024L;
    }

    public synchronized long getRetryInterval() {
        if (TbsDownloader.getRetryIntervalInSeconds() >= 0L) {
            return TbsDownloader.getRetryIntervalInSeconds();
        }
        int n2 = TbsPVConfig.getInstance(this.b).getCfgRequestMinInterval();
        if (n2 >= 0) {
            return n2;
        }
        long l2 = this.mPreferences.getLong("retry_interval", 86400L);
        return l2;
    }

    public synchronized long getDownloadMinFreeSpace() {
        int n2 = this.mPreferences.getInt("tbs_download_min_free_space", 0);
        n2 = n2 == 0 ? 0 : n2;
        return (long)(n2 * 1024) * 1024L;
    }

    public synchronized int getDownloadSuccessMaxRetrytimes() {
        int n2 = this.mPreferences.getInt("tbs_download_success_max_retrytimes", 0);
        return n2 == 0 ? 3 : n2;
    }

    public synchronized int getDownloadFailedMaxRetrytimes() {
        int n2 = this.mPreferences.getInt("tbs_download_failed_max_retrytimes", 0);
        return n2 == 0 ? 100 : n2;
    }

    public synchronized void setTbsCoreLoadRenameFileLockWaitEnable(boolean bl) {
        try {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.putBoolean("tbs_core_load_rename_file_lock_wait_enable", bl);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean getTbsCoreLoadRenameFileLockWaitEnable() {
        boolean bl = true;
        try {
            bl = this.mPreferences.getBoolean("tbs_core_load_rename_file_lock_wait_enable", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public synchronized void uploadDownloadInterruptCodeIfNeeded(Context context) {
        block9: {
            try {
                Object object;
                boolean bl;
                int n2;
                block10: {
                    if (context == null) break block9;
                    n2 = -99;
                    bl = true;
                    boolean bl2 = this.mPreferences.contains("tbs_download_interrupt_code");
                    if (!bl2) {
                        object = new File(this.b.getFilesDir(), "shared_prefs");
                        File file = new File((File)object, "tbs_download_config");
                        try {
                            if (!file.exists()) {
                                n2 = -97;
                                break block10;
                            }
                            if (!this.mPreferences.contains("tbs_needdownload")) {
                                n2 = -96;
                                break block10;
                            }
                            n2 = -101;
                        }
                        catch (Throwable throwable) {
                            n2 = -95;
                        }
                    } else {
                        n2 = this.mPreferences.getInt("tbs_download_interrupt_code", -99);
                        bl = this.a(n2);
                    }
                }
                if (bl) {
                    object = TbsLogReport.getInstance(context).tbsLogInfo();
                    ((TbsLogReport.TbsLogInfo)object).setErrorCode(128);
                    ((TbsLogReport.TbsLogInfo)object).setFailDetail(" " + n2);
                    TbsLogReport.getInstance(context).eventReport(TbsLogReport.EventType.TYPE_DOWNLOAD, (TbsLogReport.TbsLogInfo)object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean a(int n2) {
        if (n2 <= -206 && n2 >= -219) {
            return true;
        }
        if (n2 <= -302 && n2 >= -316) {
            return true;
        }
        return n2 <= -318 && n2 >= -322;
    }

    public synchronized long getDownloadSingleTimeout() {
        long l2 = this.mPreferences.getLong("tbs_single_timeout", 0L);
        return l2 == 0L ? 1200000L : l2;
    }

    public synchronized int getDownloadInterruptCode() {
        int n2;
        block9: {
            n2 = -99;
            boolean bl = this.mPreferences.contains("tbs_download_interrupt_code");
            if (!bl) {
                try {
                    if (!new File(new File(this.b.getFilesDir(), "shared_prefs"), "tbs_download_config").exists()) {
                        n2 = -97;
                        break block9;
                    }
                    if (!this.mPreferences.contains("tbs_needdownload")) {
                        n2 = -96;
                        break block9;
                    }
                    n2 = -101;
                }
                catch (Throwable throwable) {
                    n2 = -95;
                }
            } else {
                n2 = this.mPreferences.getInt("tbs_download_interrupt_code", -99);
                if (n2 == -119 || n2 == -121) {
                    n2 = this.mPreferences.getInt("tbs_download_interrupt_code_reason", -119);
                }
                if (System.currentTimeMillis() - this.mPreferences.getLong("tbs_download_interrupt_time", 0L) > 86400000L) {
                    n2 -= 98000;
                }
            }
        }
        if (this.b != null && "com.tencent.mobileqq".equals(this.b.getApplicationInfo().packageName) && !"CN".equals(Locale.getDefault().getCountry())) {
            return -320;
        }
        int n3 = this.mPreferences.getInt("tbs_install_interrupt_code", -1);
        return n2 * 1000 + n3;
    }

    public synchronized void setDownloadInterruptCode(int n2) {
        try {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.putInt("tbs_download_interrupt_code", n2);
            editor.putLong("tbs_download_interrupt_time", System.currentTimeMillis());
            editor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isOverSea() {
        return this.mPreferences.getBoolean("is_oversea", false);
    }

    public synchronized void commit() {
        try {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            Set<String> set = this.mSyncMap.keySet();
            for (String string : set) {
                Object object = this.mSyncMap.get(string);
                if (object instanceof String) {
                    editor.putString(string, (String)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    editor.putBoolean(string, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof Long) {
                    editor.putLong(string, ((Long)object).longValue());
                    continue;
                }
                if (object instanceof Integer) {
                    editor.putInt(string, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Float)) continue;
                editor.putFloat(string, ((Float)object).floatValue());
            }
            editor.commit();
            this.mSyncMap.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clear() {
        try {
            this.mSyncMap.clear();
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.clear();
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setInstallInterruptCode(int n2) {
        SharedPreferences.Editor editor = this.mPreferences.edit();
        editor.putInt("tbs_install_interrupt_code", n2);
        editor.commit();
    }

    public static interface TbsConfigKey {
        public static final String KEY_LAST_CHECK = "last_check";
        public static final String KEY_LAST_REQUEST_SUCCESS = "last_request_success";
        public static final String KEY_REQUEST_FAIL = "request_fail";
        public static final String KEY_COUNT_REQUEST_FAIL_IN_24HOURS = "count_request_fail_in_24hours";
        public static final String KEY_LAST_DOWNLOAD_DECOUPLE_CORE = "last_download_decouple_core";
        public static final String KEY_LAST_DOWNLOAD_STABLE_CORE_OTHER_CPU = "last_download_stable_core_other_cpu";
        public static final String KEY_TBS_DOWNLOAD_V = "tbs_download_version";
        public static final String KEY_TBS_DOWNLOAD_V_TYPE = "tbs_download_version_type";
        public static final String KEY_NEEDDOWNLOAD = "tbs_needdownload";
        public static final String KEY_FULL_PACKAGE = "request_full_package";
        public static final String KEY_TBSDOWNLOADURL = "tbs_downloadurl";
        public static final String KEY_DOWNLOADURL_LIST = "tbs_downloadurl_list";
        public static final String KEY_TBSAPKFILESIZE = "tbs_apkfilesize";
        public static final String KEY_CPUTYPE_OTHER_STABLE_CORE = "tbs_cpu_type_other_stable_core";
        public static final String KEY_TBSAPK_MD5 = "tbs_apk_md5";
        public static final String KEY_RESPONSECODE = "tbs_responsecode";
        public static final String KEY_DECOUPLECOREVERSION = "tbs_decouplecoreversion";
        public static final String KEY_DOWNLOADDECOUPLECORE = "tbs_downloaddecouplecore";
        public static final String KEY_APP_VERSIONNAME = "app_versionname";
        public static final String KEY_APP_VERSIONCODE = "app_versioncode";
        public static final String KEY_APP_METADATA = "app_metadata";
        public static final String KEY_APP_VERSIONCODE_FOR_SWITCH = "app_versioncode_for_switch";
        public static final String KEY_DOWNLOAD_MAXFLOW = "tbs_download_maxflow";
        public static final String KEY_DOWNLOAD_SUCCESS_MAX_RETRYTIMES = "tbs_download_success_max_retrytimes";
        public static final String KEY_DOWNLOAD_SUCCESS_RETRYTIMES = "tbs_download_success_retrytimes";
        public static final String KEY_DOWNLOAD_FAILED_MAX_RETRYTIMES = "tbs_download_failed_max_retrytimes";
        public static final String KEY_DOWNLOAD_FAILED_RETRYTIMES = "tbs_download_failed_retrytimes";
        public static final String KEY_DOWNLOAD_MIN_FREE_SPACE = "tbs_download_min_free_space";
        public static final String KEY_DOWNLOAD_SINGLE_TIMEOUT = "tbs_single_timeout";
        public static final String KEY_TBSDOWNLOAD_STARTTIME = "tbs_downloadstarttime";
        public static final String KEY_TBSDOWNLOAD_FLOW = "tbs_downloadflow";
        public static final String KEY_DEVICE_CPUABI = "device_cpuabi";
        public static final String KEY_IS_OVERSEA = "is_oversea";
        public static final String KEY_RETRY_INTERVAL = "retry_interval";
        public static final String KEY_DESkEY_TOKEN = "tbs_deskey_token";
        public static final String KEY_DOWNLOAD_INTERRUPT_CODE = "tbs_download_interrupt_code";
        public static final String KEY_DOWNLOAD_INTERRUPT_CODE_REASON = "tbs_download_interrupt_code_reason";
        public static final String KEY_INSTALL_INTERRUPT_CODE = "tbs_install_interrupt_code";
        public static final String KEY_DOWNLOAD_INTERRUPT_TIME = "tbs_download_interrupt_time";
        public static final String KEY_LAST_THIRDAPP_SENDREQUEST_COREVERSION = "last_thirdapp_sendrequest_coreversion";
        public static final String KEY_USE_BACKUP_VERSION = "use_backup_version";
        public static final String KEY_SWITCH_BACKUPCORE_ENABLE = "switch_backupcore_enable";
        public static final String KEY_BACKUPCORE_DELFILELIST = "backupcore_delfilelist";
        public static final String KEY_STOP_PRE_OAT = "tbs_stop_preoat";
        public static final String KEY_GUID = "tbs_guid";
        public static final String KEY_USE_BUGLY = "tbs_use_bugly";
        public static final String KEY_TBS_CORE_LOAD_RENAME_FILE_LOCK_WAIT_ENABLE = "tbs_core_load_rename_file_lock_wait_enable";
    }
}

