/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.utils.TbsLog;

public class Apn {
    public static final int APN_UNKNOWN = 0;
    public static final int APN_2G = 1;
    public static final int APN_3G = 2;
    public static final int APN_WIFI = 3;
    public static final int APN_4G = 4;

    public static String getApnInfo(Context context) {
        String string = "unknown";
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                switch (networkInfo.getType()) {
                    case 1: {
                        string = "wifi";
                        break;
                    }
                    case 0: {
                        try {
                            Object object = QbSdk.getSettings().get("NetworkInfo_getExtraInfo");
                            if (object != null && "prohibit".equals(String.valueOf(object))) {
                                TbsLog.i("Apn", "getApnInfo networkInfo.getExtraInfo() prohibit");
                                break;
                            }
                            TbsLog.i("Apn", "getApnInfo networkInfo.getExtraInfo() allow");
                            string = networkInfo.getExtraInfo();
                        }
                        catch (Throwable throwable) {
                            TbsLog.i("Apn", "stack is " + Log.getStackTraceString((Throwable)throwable));
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static int getApnType(Context context) {
        int n2 = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
            block0 : switch (networkInfo.getType()) {
                case 1: {
                    n2 = 3;
                    break;
                }
                case 0: {
                    switch (networkInfo.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            n2 = 1;
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            n2 = 2;
                            break block0;
                        }
                        case 13: {
                            n2 = 4;
                            break block0;
                        }
                    }
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isConnected() || networkInfo.isAvailable();
    }
}

