/*
 * Copyright (C) 2016 AriaLyy(https://github.com/AriaLyy/Aria)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.arialyy.aria.http;

import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.task.AbsThreadTaskAdapter;

/**
 * @author lyy
 * Date: 2019-09-22
 */
public abstract class BaseHttpThreadTaskAdapter extends AbsThreadTaskAdapter {
  protected HttpTaskOption mTaskOption;

  protected BaseHttpThreadTaskAdapter(SubThreadConfig config) {
    super(config);
    mTaskOption = (HttpTaskOption) getTaskWrapper().getTaskOption();
  }

  protected String getFileName() {
    return getEntity().getFileName();
  }

  protected AbsNormalEntity getEntity() {
    return (AbsNormalEntity) getTaskWrapper().getEntity();
  }
}
