/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp;

import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaSFTPException;
import com.arialyy.aria.sftp.SFtpSessionManager;
import com.arialyy.aria.sftp.SFtpTaskOption;
import com.arialyy.aria.sftp.SFtpUtil;
import com.arialyy.aria.util.CommonUtil;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.UnsupportedEncodingException;

public abstract class AbsSFtpInfoTask<WP extends AbsTaskWrapper>
implements IInfoTask {
    protected String TAG = CommonUtil.getClassName((Object)this);
    private IInfoTask.Callback callback;
    private WP wrapper;
    private SFtpTaskOption option;
    private boolean isStop = false;
    private boolean isCancel = false;

    public AbsSFtpInfoTask(WP wp) {
        this.wrapper = wp;
        this.option = (SFtpTaskOption)this.wrapper.getTaskOption();
    }

    protected abstract void getFileInfo(Session var1) throws JSchException, UnsupportedEncodingException, SftpException;

    public void stop() {
        this.isStop = true;
    }

    public void cancel() {
        this.isCancel = true;
    }

    protected void handleFail(AriaException e, boolean needRetry) {
        if (this.isStop || this.isCancel) {
            return;
        }
        this.callback.onFail(this.getWrapper().getEntity(), e, needRetry);
    }

    protected void onSucceed(CompleteInfo info) {
        if (this.isStop || this.isCancel) {
            return;
        }
        this.callback.onSucceed(this.getWrapper().getKey(), info);
    }

    public void run() {
        try {
            FtpUrlEntity entity = this.option.getUrlEntity();
            String key = CommonUtil.getStrMd5((String)(entity.hostName + entity.port + entity.user + 0));
            Session session = SFtpSessionManager.getInstance().getSession(key);
            if (session == null) {
                session = SFtpUtil.getInstance().getSession(entity, 0);
            }
            this.getFileInfo(session);
        }
        catch (JSchException e) {
            this.fail((AriaException)new AriaSFTPException("jsch\u9519\u8bef", (Exception)((Object)e)), false);
        }
        catch (UnsupportedEncodingException e) {
            this.fail((AriaException)new AriaSFTPException("\u5b57\u7b26\u7f16\u7801\u9519\u8bef", (Exception)e), false);
        }
        catch (SftpException e) {
            this.fail((AriaException)new AriaSFTPException("sftp\u9519\u8bef\uff0c\u9519\u8bef\u7c7b\u578b\uff1a" + e.id, (Exception)((Object)e)), false);
        }
    }

    protected SFtpTaskOption getOption() {
        return this.option;
    }

    protected WP getWrapper() {
        return this.wrapper;
    }

    protected void fail(AriaException e, boolean needRetry) {
        this.callback.onFail(this.getWrapper().getEntity(), e, needRetry);
    }

    public void setCallback(IInfoTask.Callback callback) {
        this.callback = callback;
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IInfoTask)this);
    }
}

