/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp;

import android.text.TextUtils;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SFtpSessionManager {
    private String TAG = CommonUtil.getClassName((Object)this);
    private static volatile SFtpSessionManager INSTANCE = null;
    private Map<String, Session> sessionDeque = new HashMap<String, Session>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SFtpSessionManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SFtpSessionManager> clazz = SFtpSessionManager.class;
        synchronized (SFtpSessionManager.class) {
            INSTANCE = new SFtpSessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private SFtpSessionManager() {
    }

    public Session getSession(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            ALog.e((String)this.TAG, (String)"\u4ece\u7f13\u5b58\u83b7\u53d6session\u5931\u8d25\uff0ckey\u4e3a\u7a7a");
            return null;
        }
        Session session = this.sessionDeque.get(key);
        if (session == null) {
            ALog.w((String)this.TAG, (String)("\u4ece\u7f13\u5b58\u83b7\u53d6session\u5931\u8d25\uff0ckey\uff1a" + key));
        }
        this.cleanIdleSession();
        return session;
    }

    public void addSession(Session session, int threadId) {
        if (session == null) {
            ALog.e((String)this.TAG, (String)"\u6dfb\u52a0session\u5230\u7ba1\u7406\u5668\u5931\u8d25\uff0csession \u4e3a\u7a7a");
            return;
        }
        String key = CommonUtil.getStrMd5((String)(session.getHost() + session.getPort() + session.getUserName() + threadId));
        this.sessionDeque.put(key, session);
    }

    private void cleanIdleSession() {
        if (this.sessionDeque.size() > 0) {
            Iterator<Map.Entry<String, Session>> i = this.sessionDeque.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Session> entry = i.next();
                Session session = entry.getValue();
                if (session != null && session.isConnected()) continue;
                i.remove();
            }
        }
    }
}

