/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp;

import android.text.TextUtils;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.IdEntity;
import com.arialyy.aria.sftp.SFtpSessionManager;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class SFtpUtil {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private static SFtpUtil INSTANCE;

    private SFtpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SFtpUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SFtpUtil> clazz = SFtpUtil.class;
        synchronized (SFtpUtil.class) {
            INSTANCE = new SFtpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Session getSession(FtpUrlEntity entity, int threadId) throws JSchException, UnsupportedEncodingException {
        JSch jSch = new JSch();
        IdEntity idEntity = entity.idEntity;
        if (idEntity.prvKey != null) {
            if (idEntity.pubKey == null) {
                jSch.addIdentity(idEntity.prvKey, entity.password == null ? null : idEntity.prvPass.getBytes("UTF-8"));
            } else {
                jSch.addIdentity(idEntity.prvKey, idEntity.pubKey, entity.password == null ? null : idEntity.prvPass.getBytes("UTF-8"));
            }
        }
        this.setKnowHost(jSch, entity);
        Session session = TextUtils.isEmpty((CharSequence)entity.user) ? jSch.getSession(null, entity.hostName, Integer.parseInt(entity.port)) : jSch.getSession(entity.user, entity.hostName, Integer.parseInt(entity.port));
        if (!TextUtils.isEmpty((CharSequence)entity.password)) {
            session.setPassword(entity.password);
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setTimeout(5000);
        session.setIdentityRepository(jSch.getIdentityRepository());
        session.connect();
        SFtpSessionManager.getInstance().addSession(session, threadId);
        return session;
    }

    private void setKnowHost(JSch jSch, FtpUrlEntity entity) throws JSchException {
        IdEntity idEntity = entity.idEntity;
        if (idEntity.knowHost != null) {
            File knowFile = new File(idEntity.knowHost);
            if (!knowFile.exists()) {
                FileUtil.createFile((File)knowFile);
            }
            jSch.setKnownHosts(idEntity.knowHost);
        }
    }

    private byte[] getPubKey(String pubKeyPath) {
        try {
            File f = new File(pubKeyPath);
            FileInputStream fis = new FileInputStream(f);
            byte[] buf = new byte[(int)f.length()];
            int len = fis.read(buf);
            fis.close();
            return buf;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class JschUserInfo
    implements UserInfo {
        private JschUserInfo() {
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassword(String message) {
            System.out.println(message);
            return true;
        }

        public boolean promptPassphrase(String message) {
            System.out.println(message);
            return false;
        }

        public boolean promptYesNo(String message) {
            System.out.println(message);
            return false;
        }

        public void showMessage(String message) {
            System.out.println(message);
        }
    }
}

