/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp.download;

import android.os.Handler;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.loader.AbsNormalTTBuilderAdapter;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.sftp.SFtpSessionManager;
import com.arialyy.aria.sftp.SFtpTaskOption;
import com.arialyy.aria.sftp.SFtpUtil;
import com.arialyy.aria.sftp.download.SFtpDThreadTaskAdapter;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.UnsupportedEncodingException;

final class SFtpDTTBuilderAdapter
extends AbsNormalTTBuilderAdapter {
    private SFtpTaskOption option;

    SFtpDTTBuilderAdapter(DTaskWrapper wrapper) {
        this.option = (SFtpTaskOption)wrapper.getTaskOption();
    }

    public IThreadTaskAdapter getAdapter(SubThreadConfig config) {
        return new SFtpDThreadTaskAdapter(config);
    }

    protected SubThreadConfig getSubThreadConfig(Handler stateHandler, ThreadRecord threadRecord, boolean isBlock, int startNum) {
        SubThreadConfig config = super.getSubThreadConfig(stateHandler, threadRecord, isBlock, startNum);
        FtpUrlEntity entity = this.option.getUrlEntity();
        String key = CommonUtil.getStrMd5((String)(entity.hostName + entity.port + entity.user + threadRecord.threadId));
        Session session = SFtpSessionManager.getInstance().getSession(key);
        if (session == null) {
            try {
                session = SFtpUtil.getInstance().getSession(entity, threadRecord.threadId);
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        config.obj = session;
        return config;
    }

    public boolean handleNewTask(TaskRecord record, int totalThreadNum) {
        if (!record.isBlock) {
            if (this.getTempFile().exists()) {
                FileUtil.deleteFile((File)this.getTempFile());
            }
        } else {
            for (int i = 0; i < totalThreadNum; ++i) {
                File blockFile = new File(String.format("%s.%s.part", this.getTempFile().getPath(), i));
                if (!blockFile.exists()) continue;
                ALog.d((String)this.TAG, (String)String.format("\u5206\u5757\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\uff0c\u5c06\u5220\u9664\u8be5\u5206\u5757", i));
                FileUtil.deleteFile((File)blockFile);
            }
        }
        return true;
    }
}

