/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp.download;

import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.task.AbsThreadTaskAdapter;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaSFTPException;
import com.arialyy.aria.sftp.SFtpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

final class SFtpDThreadTaskAdapter
extends AbsThreadTaskAdapter {
    private ChannelSftp channelSftp;
    private Session session;
    private SFtpTaskOption option;

    SFtpDThreadTaskAdapter(SubThreadConfig config) {
        super(config);
        this.session = (Session)config.obj;
        this.option = (SFtpTaskOption)this.getTaskWrapper().getTaskOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerThreadTask() {
        if (this.session == null) {
            this.fail((AriaException)new AriaSFTPException("session \u4e3a\u7a7a"), false);
            return;
        }
        try {
            int timeout = this.getTaskConfig().getConnectTimeOut();
            if (!this.session.isConnected()) {
                this.session.connect(timeout);
            }
            this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            this.channelSftp.connect(timeout);
            ALog.d((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5f00\u59cb\u4e0b\u8f7d\u3010\u5f00\u59cb\u4f4d\u7f6e : %s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s\u3011", this.getTaskWrapper().getKey(), this.getThreadRecord().threadId, this.getThreadRecord().startLocation, this.getThreadRecord().endLocation));
            String charSet = this.option.getCharSet();
            String remotePath = CommonUtil.convertSFtpChar((String)charSet, (String)this.option.getUrlEntity().remotePath);
            this.download(remotePath);
        }
        catch (SftpException e) {
            this.fail((AriaException)new AriaSFTPException("sftp\u9519\u8bef\uff0c\u9519\u8bef\u7c7b\u578b\uff1a" + e.id, (Exception)((Object)e)), false);
        }
        catch (UnsupportedEncodingException e) {
            this.fail((AriaException)new AriaSFTPException("\u5b57\u7b26\u7f16\u7801\u9519\u8bef", (Exception)e), false);
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaSFTPException("", (Exception)e), true);
        }
        catch (JSchException e) {
            this.fail((AriaException)new AriaSFTPException("jsch \u9519\u8bef", (Exception)((Object)e)), false);
        }
        finally {
            this.channelSftp.disconnect();
        }
    }

    private void download(String remotePath) throws SftpException, IOException {
        int len;
        InputStream is = this.channelSftp.get(remotePath, (SftpProgressMonitor)new Monitor(), this.getThreadRecord().startLocation);
        FileOutputStream fos = new FileOutputStream(this.getThreadConfig().tempFile, true);
        FileChannel foc = fos.getChannel();
        ReadableByteChannel fic = Channels.newChannel(is);
        ByteBuffer bf = ByteBuffer.allocate(this.getTaskConfig().getBuffSize());
        while (this.getThreadTask().isLive() && (len = fic.read(bf)) != -1 && !this.getThreadTask().isBreak()) {
            if (this.mSpeedBandUtil != null) {
                this.mSpeedBandUtil.limitNextBytes(len);
            }
            if (this.getRangeProgress() + (long)len >= this.getThreadRecord().endLocation) {
                len = (int)(this.getThreadRecord().endLocation - this.getRangeProgress());
                bf.flip();
                fos.write(bf.array(), 0, len);
                bf.compact();
                this.progress(len);
                break;
            }
            bf.flip();
            foc.write(bf);
            bf.compact();
            this.progress(len);
        }
        fos.flush();
        fos.close();
        is.close();
    }

    private class Monitor
    implements SftpProgressMonitor {
        private Monitor() {
        }

        public void init(int op, String src, String dest, long max) {
            ALog.d((String)SFtpDThreadTaskAdapter.this.TAG, (String)String.format("op = %s; src = %s; dest = %s; max = %s", op, src, dest, max));
        }

        public boolean count(long count) {
            if (SFtpDThreadTaskAdapter.this.getRangeProgress() > ((SFtpDThreadTaskAdapter)SFtpDThreadTaskAdapter.this).getThreadRecord().endLocation) {
                return false;
            }
            return !SFtpDThreadTaskAdapter.this.getThreadTask().isBreak();
        }

        public void end() {
            if (SFtpDThreadTaskAdapter.this.getThreadTask().isBreak()) {
                return;
            }
            SFtpDThreadTaskAdapter.this.complete();
        }
    }
}

