/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp.upload;

import android.os.Handler;
import android.os.Looper;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IDLoadListener;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.AbsNormalLoader;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.sftp.upload.SFtpURecordHandler;
import com.arialyy.aria.util.FileUtil;
import com.jcraft.jsch.SftpATTRS;
import java.io.File;

final class SFtpULoader
extends AbsNormalLoader<UTaskWrapper> {
    private Looper looper;

    SFtpULoader(UTaskWrapper wrapper, IEventListener listener) {
        super((AbsTaskWrapper)wrapper, listener);
        this.mTempFile = new File(this.getEntity().getFilePath());
        EventMsgUtil.getDefault().register((Object)this);
        this.setUpdateInterval(wrapper.getConfig().getUpdateInterval());
    }

    private UploadEntity getEntity() {
        return (UploadEntity)((UTaskWrapper)this.mTaskWrapper).getEntity();
    }

    public long getFileSize() {
        return this.getEntity().getFileSize();
    }

    protected void setMaxSpeed(int maxSpeed) {
        for (IThreadTask threadTask : this.getTaskList()) {
            if (threadTask == null) continue;
            threadTask.setMaxSpeed(maxSpeed);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        EventMsgUtil.getDefault().unRegister((Object)this);
    }

    public void handleTask(Looper looper) {
        if (this.isBreak()) {
            return;
        }
        this.looper = looper;
        this.mInfoTask.run();
    }

    private void startThreadTask(SftpATTRS attrs) {
        File file;
        if (this.isBreak()) {
            return;
        }
        if (this.getListener() instanceof IDLoadListener) {
            ((IDLoadListener)this.getListener()).onPostPre(this.getEntity().getFileSize());
        }
        if ((file = new File(this.getEntity().getFilePath())).getParentFile() != null && !file.getParentFile().exists()) {
            FileUtil.createDir((String)file.getPath());
        }
        SFtpURecordHandler recordHandler = (SFtpURecordHandler)this.mRecordHandler;
        recordHandler.setFtpAttrs(attrs);
        this.mRecord = recordHandler.getRecord(this.getFileSize());
        this.mStateManager.setLooper(this.mRecord, this.looper);
        this.getTaskList().addAll(this.mTTBuilder.buildThreadTask(this.mRecord, new Handler(this.looper, this.mStateManager.getHandlerCallback())));
        this.mStateManager.updateCurrentProgress(this.getEntity().getCurrentProgress());
        if (this.mStateManager.getCurrentProgress() > 0L) {
            this.getListener().onResume(this.mStateManager.getCurrentProgress());
        } else {
            this.getListener().onStart(this.mStateManager.getCurrentProgress());
        }
        for (IThreadTask threadTask : this.getTaskList()) {
            ThreadTaskManager.getInstance().startThread(((UTaskWrapper)this.mTaskWrapper).getKey(), threadTask);
        }
        this.startTimer();
    }

    public long getCurrentProgress() {
        return this.isRunning() ? this.mStateManager.getCurrentProgress() : this.getEntity().getCurrentProgress();
    }

    public void addComponent(IRecordHandler recordHandler) {
        this.mRecordHandler = recordHandler;
    }

    public void addComponent(IInfoTask infoTask) {
        this.mInfoTask = infoTask;
        infoTask.setCallback(new IInfoTask.Callback(){

            public void onSucceed(String key, CompleteInfo info) {
                if (info.code == 161) {
                    SFtpULoader.this.getListener().onComplete();
                } else {
                    SFtpULoader.this.startThreadTask((SftpATTRS)info.obj);
                }
            }

            public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
                SFtpULoader.this.getListener().onFail(needRetry, e);
            }
        });
    }

    public void addComponent(IThreadStateManager threadState) {
        this.mStateManager = threadState;
    }

    public void addComponent(IThreadTaskBuilder builder) {
        this.mTTBuilder = builder;
    }
}

