/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.sftp.upload;

import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.task.AbsThreadTaskAdapter;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaSFTPException;
import com.arialyy.aria.sftp.SFtpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.BufferedRandomAccessFile;
import com.arialyy.aria.util.CommonUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

final class SFtpUThreadTaskAdapter
extends AbsThreadTaskAdapter {
    private ChannelSftp channelSftp;
    private Session session;
    private SFtpTaskOption option;

    SFtpUThreadTaskAdapter(SubThreadConfig config) {
        super(config);
        this.session = (Session)config.obj;
        this.option = (SFtpTaskOption)this.getTaskWrapper().getTaskOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerThreadTask() {
        if (this.session == null) {
            this.fail((AriaException)new AriaSFTPException("session \u4e3a\u7a7a"), false);
            return;
        }
        try {
            ALog.d((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5f00\u59cb\u4e0a\u4f20\u3010\u5f00\u59cb\u4f4d\u7f6e : %s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s\u3011", this.getTaskWrapper().getKey(), this.getThreadRecord().threadId, this.getThreadRecord().startLocation, this.getThreadRecord().endLocation));
            int timeout = this.getTaskConfig().getConnectTimeOut();
            if (!this.session.isConnected()) {
                this.session.connect(timeout);
            }
            String charSet = this.option.getCharSet();
            String remotePath = CommonUtil.convertSFtpChar((String)charSet, (String)this.option.getUrlEntity().remotePath);
            this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            this.channelSftp.connect(timeout);
            if (!this.dirIsExist(remotePath)) {
                this.createDir(remotePath);
            }
            this.channelSftp.cd(remotePath);
            this.upload(remotePath);
        }
        catch (SftpException e) {
            this.fail((AriaException)new AriaSFTPException("sftp\u9519\u8bef\uff0c\u9519\u8bef\u7c7b\u578b\uff1a" + e.id, (Exception)((Object)e)), false);
        }
        catch (UnsupportedEncodingException e) {
            this.fail((AriaException)new AriaSFTPException("\u5b57\u7b26\u7f16\u7801\u9519\u8bef", (Exception)e), false);
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaSFTPException("", (Exception)e), true);
        }
        catch (JSchException e) {
            this.fail((AriaException)new AriaSFTPException("jsch \u9519\u8bef", (Exception)((Object)e)), false);
        }
        finally {
            this.channelSftp.disconnect();
        }
    }

    private boolean dirIsExist(String remotePath) {
        try {
            this.channelSftp.ls(remotePath);
        }
        catch (SftpException e) {
            return false;
        }
        return true;
    }

    private void createDir(String remotePath) throws SftpException {
        String[] folders;
        for (String folder : folders = remotePath.split("/")) {
            if (folder.length() <= 0) continue;
            try {
                this.channelSftp.cd(folder);
            }
            catch (SftpException e) {
                this.channelSftp.mkdir(folder);
                this.channelSftp.cd(folder);
            }
        }
    }

    private void upload(String remotePath) throws SftpException, IOException {
        int bytesRead;
        UploadEntity entity = (UploadEntity)this.getTaskWrapper().getEntity();
        remotePath = remotePath.concat("/").concat(entity.getFileName());
        BufferedRandomAccessFile brf = new BufferedRandomAccessFile(this.getThreadConfig().tempFile, "r");
        int mode = 0;
        boolean isResume = false;
        if (this.getThreadRecord().startLocation > 0L) {
            brf.seek(this.getThreadRecord().startLocation);
            mode = 2;
            isResume = true;
        }
        OutputStream os = this.channelSftp.put(remotePath, (SftpProgressMonitor)new Monitor(isResume), mode);
        byte[] buffer = new byte[4096];
        while ((bytesRead = brf.read(buffer)) != -1 && !this.getThreadTask().isBreak()) {
            os.write(buffer, 0, bytesRead);
            if (this.mSpeedBandUtil == null) continue;
            this.mSpeedBandUtil.limitNextBytes(bytesRead);
        }
        os.flush();
        os.close();
        brf.close();
    }

    private class Monitor
    implements SftpProgressMonitor {
        private boolean isResume;

        private Monitor(boolean isResume) {
            this.isResume = isResume;
        }

        public void init(int op, String src, String dest, long max) {
            ALog.d((String)SFtpUThreadTaskAdapter.this.TAG, (String)String.format("op = %s; src = %s; dest = %s; max = %s", op, src, dest, max));
        }

        public boolean count(long count) {
            if (!this.isResume) {
                SFtpUThreadTaskAdapter.this.progress(count);
            }
            this.isResume = false;
            return !SFtpUThreadTaskAdapter.this.getThreadTask().isBreak();
        }

        public void end() {
            if (SFtpUThreadTaskAdapter.this.getThreadTask().isBreak()) {
                return;
            }
            SFtpUThreadTaskAdapter.this.complete();
        }
    }
}

