/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvdbtext.tokenizer;

import com.tencent.tcvdbtext.hash.BaseHash;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseTokenizer {
    protected BaseHash hash;
    protected Set<String> stopWords;
    protected Boolean lowerCase;
    protected String dictFilePath;
    protected Boolean enableStopWords;

    public BaseTokenizer(BaseHash hash, Boolean enableStopWords, Set<String> stopWords, Boolean lowerCase, String dictFilePath) {
        this.hash = hash;
        this.stopWords = stopWords;
        this.lowerCase = lowerCase;
        this.dictFilePath = dictFilePath;
        this.enableStopWords = enableStopWords;
    }

    public BaseTokenizer() {
    }

    public Boolean getEnableStopWords() {
        return this.enableStopWords;
    }

    public void setEnableStopWords(Boolean enableStopWords) {
        this.enableStopWords = enableStopWords;
    }

    public abstract List<String> tokenize(String var1);

    public abstract List<Long> encode(String var1);

    public abstract String decode(List<Integer> var1);

    public Map<String, Object> getParameter() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("hash", this.hash.getClass().getName());
        param.put("stopWords", this.stopWords);
        param.put("lowerCase", this.lowerCase);
        param.put("dictFilePath", this.dictFilePath);
        param.put("enableStopWords", this.enableStopWords);
        return param;
    }

    public void updateParameter(BaseHash hash, Set<String> stopWords, Boolean enableStopWords, Boolean lowerCase, String dictFilePath) {
        this.hash = hash;
        this.stopWords = stopWords;
        this.lowerCase = lowerCase;
        this.dictFilePath = dictFilePath;
        this.enableStopWords = enableStopWords;
    }

    public boolean isStopWord(String word) {
        if (this.stopWords.isEmpty()) {
            return false;
        }
        return this.stopWords.contains(word);
    }

    public abstract void loadDict(String var1);

    public abstract void setLowerCase(Boolean var1);
}

