/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Collection {
    @JsonIgnore
    private Stub stub;
    protected String database;
    protected String collection;
    protected int replicaNum = 2;
    protected int shardNum = 1;
    protected String description;
    protected List<IndexField> indexes;
    protected String createTime;
    protected Embedding embedding;
    @JsonIgnore
    protected ReadConsistencyEnum readConsistency;
    private long documentCount;
    private IndexStatus indexStatus;
    private List<String> alias;

    protected Collection() {
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getReplicaNum() {
        return this.replicaNum;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public String getDescription() {
        return this.description;
    }

    public List<IndexField> getIndexes() {
        return this.indexes;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Embedding getEmbedding() {
        return this.embedding;
    }

    public long getDocumentCount() {
        return this.documentCount;
    }

    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ReadConsistencyEnum readConsistency) {
        this.readConsistency = readConsistency;
    }

    public AffectRes upsert(InsertParam param) throws VectorDBException {
        InsertParamInner insertParam = new InsertParamInner(this.database, this.collection, param);
        return this.stub.upsertDocument(insertParam);
    }

    public List<Document> query(QueryParam param) throws VectorDBException {
        return this.stub.queryDocument(new QueryParamInner(this.database, this.collection, param, this.readConsistency));
    }

    public List<List<Document>> search(SearchByVectorParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(this.database, this.collection, param, this.readConsistency)).getDocuments();
    }

    public List<List<Document>> searchById(SearchByIdParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(this.database, this.collection, param, this.readConsistency)).getDocuments();
    }

    public SearchRes searchByEmbeddingItems(SearchByEmbeddingItemsParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(this.database, this.collection, param, this.readConsistency));
    }

    public AffectRes delete(DeleteParam param) throws VectorDBException {
        return this.stub.deleteDocument(new DeleteParamInner(this.database, this.collection, param));
    }

    public AffectRes update(UpdateParam param, Document document) throws VectorDBException {
        return this.stub.updateDocument(new UpdateParamInner(this.database, this.collection, param, document));
    }

    public BaseRes rebuildIndex(RebuildIndexParam rebuildIndexParam) {
        return this.stub.rebuildIndex(new RebuildIndexParamInner(this.database, this.collection, rebuildIndexParam));
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new ParamException(String.format("Create collection param error: %s", new Object[]{e}));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IndexStatus {
        private String status;
        private Date startTime;

        public String getStatus() {
            return this.status;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return "IndexStatus{status='" + this.status + '\'' + ", startTime=" + this.startTime + '}';
        }
    }
}

