/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import java.util.List;

public class Database {
    private final Stub stub;
    private final String databaseName;
    @JsonIgnore
    private final ReadConsistencyEnum readConsistency;

    public Database(Stub stub, String databaseName, ReadConsistencyEnum readConsistency) {
        this.stub = stub;
        this.databaseName = databaseName;
        this.readConsistency = readConsistency;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public Collection createCollection(CreateCollectionParam param) throws VectorDBException {
        param.setDatabase(this.databaseName);
        param.setReadConsistency(this.readConsistency);
        this.stub.createCollection(param);
        param.setStub(this.stub);
        return param;
    }

    public List<Collection> listCollections() throws VectorDBException {
        List<Collection> collections = this.stub.listCollections(this.databaseName);
        collections.forEach(c -> {
            c.setStub(this.stub);
            c.setReadConsistency(this.readConsistency);
        });
        return collections;
    }

    public AffectRes truncateCollections(String collectionName) {
        return this.stub.truncateCollection(this.databaseName, collectionName);
    }

    public Collection describeCollection(String collectionName) throws VectorDBException {
        Collection collection = this.stub.describeCollection(this.databaseName, collectionName);
        collection.setStub(this.stub);
        collection.setReadConsistency(this.readConsistency);
        return collection;
    }

    public void dropCollection(String collectionName) throws VectorDBException {
        this.stub.dropCollection(this.databaseName, collectionName);
    }

    public AffectRes setAlias(String collectionName, String aliasName) {
        return this.stub.setAlias(this.databaseName, collectionName, aliasName);
    }

    public AffectRes deleteAlias(String aliasName) {
        return this.stub.deleteAlias(this.databaseName, aliasName);
    }

    public Collection collection(String collectionName) throws VectorDBException {
        return this.describeCollection(collectionName);
    }

    public String toString() {
        return String.format("{\"database\":\"%s\"}", this.databaseName);
    }
}

